/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client.render;

import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.data.ModelData;
import xyz.przemyk.simpleplanes.setup.SimplePlanesComponents;

public class PlaneItemColors {
    public static final HashMap<Block, Integer> cachedColors = new HashMap();
    public static final int DEFAULT_COLOR = -5075115;

    public static void clearCache() {
        cachedColors.clear();
    }

    public static int getColor(ItemStack itemStack, int tintIndex) {
        Block block;
        CompoundTag entityTag = (CompoundTag)itemStack.get(SimplePlanesComponents.ENTITY_TAG);
        if (tintIndex != 0) {
            return -1;
        }
        if (entityTag != null && entityTag.contains("material") && (block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)entityTag.getString("material")))) != null) {
            if (cachedColors.containsKey(block)) {
                return cachedColors.get(block);
            }
            try {
                TextureAtlasSprite sprite = ((BakedQuad)Minecraft.getInstance().getModelManager().getModel(new ModelResourceLocation(BuiltInRegistries.BLOCK.getKey((Object)block), "inventory")).getQuads(null, Direction.SOUTH, RandomSource.create(), ModelData.EMPTY, null).getFirst()).getSprite();
                int g = 0;
                int b = 0;
                int a = 0;
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        int pixelRGBA = sprite.getPixelRGBA(0, x, y);
                        g += (pixelRGBA & 0xFF0000) >>> 16;
                        b += (pixelRGBA & 0xFF00) >>> 8;
                        a += pixelRGBA & 0xFF;
                    }
                }
                g /= 256;
                b /= 256;
                a /= 256;
                int redo = (g = (int)Math.min(255.0, (double)g * 1.1)) | (b = (int)Math.min(255.0, (double)b * 1.1)) << 8 | (a = (int)Math.min(255.0, (double)a * 1.1)) << 16;
                if (redo < 0) {
                    redo = 0xFFFFFF - redo;
                }
                cachedColors.put(block, redo |= 0xFF000000);
                return redo;
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException exception) {
                cachedColors.put(block, -5075115);
                return -5075115;
            }
        }
        return -5075115;
    }
}

