/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.mixin.client;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltipClient;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.impl.hook.ContainerScreenDrawTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.hook.ContainerScreenLockTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.hook.GuiGraphicsExtensions;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public class AbstractContainerScreenMixin
implements ContainerScreenLockTooltip {
    @Shadow
    @Nullable
    protected Slot hoveredSlot;
    @Final
    @Shadow
    protected AbstractContainerMenu menu;
    @Unique
    @Nullable
    private Slot mouseLockSlot = null;
    @Unique
    private int mouseLockX = 0;
    @Unique
    private int mouseLockY = 0;

    @Shadow
    protected List<Component> getTooltipFromContainerItem(ItemStack stack) {
        return null;
    }

    @Inject(at={@At(value="HEAD")}, method={"isHovering(Lnet/minecraft/world/inventory/Slot;DD)Z"}, cancellable=true)
    private void forceFocusSlot(Slot slot, double pointX, double pointY, CallbackInfoReturnable<Boolean> cir) {
        if (this.mouseLockSlot != null) {
            if (this.mouseLockSlot.hasItem() && this.menu.slots.contains((Object)this.mouseLockSlot)) {
                cir.setReturnValue((Object)(slot == this.mouseLockSlot && this.menu.getCarried().isEmpty() ? 1 : 0));
            } else {
                this.mouseLockSlot = null;
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"})
    private void captureMousePosition(GuiGraphics graphics, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        GuiGraphicsExtensions extensions = (GuiGraphicsExtensions)graphics;
        extensions.setMouseY(mouseY);
        extensions.setMouseX(mouseX);
    }

    @Inject(at={@At(value="HEAD")}, method={"renderTooltip(Lnet/minecraft/client/gui/GuiGraphics;II)V"})
    private void enableLockKeyHints(CallbackInfo ci) {
        ShulkerBoxTooltipClient.setLockKeyHintsEnabled(true);
    }

    @Inject(at={@At(value="RETURN")}, method={"renderTooltip(Lnet/minecraft/client/gui/GuiGraphics;II)V"})
    private void disableLockKeyHints(CallbackInfo ci) {
        ShulkerBoxTooltipClient.setLockKeyHintsEnabled(false);
    }

    @Override
    public void shulkerboxtooltip$lockTooltipPosition(GuiGraphics graphics, Font font, List<Component> text, Optional<TooltipComponent> data, ItemStack stack, int x, int y) {
        Slot mouseLockSlot = this.mouseLockSlot;
        if (ShulkerBoxTooltipClient.isLockPreviewKeyPressed()) {
            if (mouseLockSlot == null) {
                mouseLockSlot = this.hoveredSlot;
                this.mouseLockX = x;
                this.mouseLockY = y;
            }
        } else {
            mouseLockSlot = null;
        }
        if (mouseLockSlot != null) {
            ItemStack mouseStack = mouseLockSlot.getItem();
            PreviewContext context = PreviewContext.builder(mouseStack).withOwner((Player)(ShulkerBoxTooltipClient.client == null ? null : ShulkerBoxTooltipClient.client.player)).build();
            if (ShulkerBoxTooltipApi.isPreviewAvailable(context)) {
                text = this.getTooltipFromContainerItem(mouseStack);
                data = mouseStack.getTooltipImage();
                stack = mouseStack;
                x = this.mouseLockX;
                y = this.mouseLockY;
            } else {
                mouseLockSlot = null;
            }
        }
        this.mouseLockSlot = mouseLockSlot;
        ContainerScreenDrawTooltip self = (ContainerScreenDrawTooltip)((Object)this);
        self.shulkerboxtooltip$drawMouseoverTooltip(graphics, font, text, data, stack, x, y);
    }
}

