/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.provider;

import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.provider.BlockEntityPreviewProvider;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.RandomizableContainer;

public class InventoryAwarePreviewProvider<I extends Container>
extends BlockEntityPreviewProvider {
    private final Supplier<? extends I> inventoryFactory;
    private final ThreadLocal<I> cachedInventory = ThreadLocal.withInitial(() -> null);

    public InventoryAwarePreviewProvider(int maxRowSize, Supplier<? extends I> inventoryFactory) {
        super(27, false, maxRowSize);
        this.inventoryFactory = inventoryFactory;
    }

    private I getInventory() {
        Container inv = (Container)this.cachedInventory.get();
        if (inv == null) {
            inv = (Container)this.inventoryFactory.get();
            this.cachedInventory.set(inv);
        }
        return (I)inv;
    }

    @Override
    public boolean showTooltipHints(PreviewContext context) {
        return this.shouldDisplay(context);
    }

    @Override
    public int getInventoryMaxSize(PreviewContext context) {
        return this.getInventory().getContainerSize();
    }

    @Override
    public boolean canUseLootTables() {
        return this.getInventory() instanceof RandomizableContainer;
    }
}

