/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.api;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltipClient;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorRegistry;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProviderRegistry;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.provider.OverridingPreviewProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public interface ShulkerBoxTooltipApi {
    @Nullable
    public static PreviewProvider getPreviewProviderForStack(ItemStack stack) {
        return PreviewProviderRegistry.getInstance().get(stack);
    }

    @Nullable
    public static PreviewProvider getPreviewProviderForStackWithOverrides(ItemStack stack) {
        return OverridingPreviewProvider.maybeWrap(ShulkerBoxTooltipApi.getPreviewProviderForStack(stack), stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isPreviewAvailable(PreviewContext context) {
        return ShulkerBoxTooltipClient.isPreviewAvailable(context);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public static PreviewType getCurrentPreviewType(boolean hasFullPreviewMode) {
        return ShulkerBoxTooltipClient.getCurrentPreviewType(hasFullPreviewMode);
    }

    public static boolean hasModAvailable(ServerPlayer player) {
        return ServerNetworking.hasModAvailable(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void registerColors(ColorRegistry registry) {
    }

    public void registerProviders(PreviewProviderRegistry var1);
}

