/*
 * Decompiled with CFR 0.152.
 */
package com.jaskarth.riverredux.mixin;

import com.jaskarth.riverredux.BiomeMaps;
import com.jaskarth.riverredux.util.StackWalk;
import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={OverworldBiomeBuilder.class})
public abstract class MixinOverworldBiomeBuilder {
    @Shadow
    @Final
    private Climate.Parameter FULL_RANGE;
    @Shadow
    @Final
    private Climate.Parameter UNFROZEN_RANGE;
    @Shadow
    @Final
    private Climate.Parameter[] erosions;
    @Shadow
    @Final
    private Climate.Parameter coastContinentalness;
    @Shadow
    @Final
    private Climate.Parameter farInlandContinentalness;
    @Shadow
    @Final
    private Climate.Parameter[] temperatures;
    @Shadow
    @Final
    private Climate.Parameter[] humidities;

    @Inject(method={"addSurfaceBiome(Ljava/util/function/Consumer;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;FLnet/minecraft/resources/ResourceKey;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void tryRemoveRiver(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome, CallbackInfo ci) {
        if (biome.equals((Object)Biomes.RIVER) && temperature.equals((Object)this.UNFROZEN_RANGE) && humidity.equals((Object)this.FULL_RANGE) && erosion.equals((Object)Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5])) && continentalness.equals((Object)Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness)) && StackWalk.isVanillaInvocOfOBB()) {
            for (int i = 0; i < this.temperatures.length; ++i) {
                Climate.Parameter parameterRange = this.temperatures[i];
                for (int j = 0; j < this.humidities.length; ++j) {
                    Climate.Parameter parameterRange2 = this.humidities[j];
                    ResourceKey<Biome> riverKeyOrNull = BiomeMaps.RR_RIVER_BIOMES[i][j];
                    if (riverKeyOrNull == null) continue;
                    this.writeCustomRivers(parameters, parameterRange, parameterRange2, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), weirdness, 0.0f, riverKeyOrNull);
                }
            }
            ci.cancel();
        }
    }

    private void writeCustomRivers(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        parameters.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)weirdness, (float)offset), biome));
        parameters.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)1.0f), (Climate.Parameter)weirdness, (float)offset), biome));
    }
}

