/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.util;

import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkSource;

public class BlockEntityHelper {
    public static void sendCustomUpdate(BlockEntity entity, BiFunction<BlockEntity, RegistryAccess, CompoundTag> update) {
        Level level = Objects.requireNonNull(entity.getLevel());
        ChunkSource chunkSource = level.getChunkSource();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache cache = (ServerChunkCache)chunkSource;
            BlockPos pos = entity.getBlockPos();
            ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.create((BlockEntity)entity, update);
            List players = cache.chunkMap.getPlayers(new ChunkPos(pos), false);
            players.forEach(player -> player.connection.send((Packet)packet));
        }
    }

    public static void saveItems(String key, CompoundTag tag, NonNullList<ItemStack> items, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.isEmpty()) continue;
            CompoundTag slot = new CompoundTag();
            slot.putByte("Slot", (byte)i);
            list.add((Object)stack.save(provider, (Tag)slot));
        }
        tag.put(key, (Tag)list);
    }

    public static void loadItems(String key, HolderLookup.Provider provider, CompoundTag tag, NonNullList<ItemStack> items) {
        items.clear();
        if (tag.contains(key, 9)) {
            ListTag list = tag.getList(key, 10);
            list.forEach(nbt -> {
                byte index;
                CompoundTag slot = (CompoundTag)nbt;
                if (slot.contains("Slot", 1) && (index = slot.getByte("Slot")) >= 0 && index < items.size()) {
                    items.set((int)index, (Object)ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)slot));
                }
            });
        }
    }

    public static NonNullList<ItemStack> nonNullListFromContainer(Container container) {
        int size = container.getContainerSize();
        NonNullList items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        for (int i = 0; i < size; ++i) {
            items.set(i, (Object)container.getItem(i));
        }
        return items;
    }
}

