/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.network.play;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.furniture.refurbished.blockentity.INameable;
import com.mrcrayfish.furniture.refurbished.blockentity.IPaintable;
import com.mrcrayfish.furniture.refurbished.blockentity.RecycleBinBlockEntity;
import com.mrcrayfish.furniture.refurbished.computer.Program;
import com.mrcrayfish.furniture.refurbished.computer.app.HomeControl;
import com.mrcrayfish.furniture.refurbished.computer.app.PaddleBall;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.inventory.ComputerMenu;
import com.mrcrayfish.furniture.refurbished.inventory.DoorMatMenu;
import com.mrcrayfish.furniture.refurbished.inventory.IPowerSwitchMenu;
import com.mrcrayfish.furniture.refurbished.inventory.PostBoxMenu;
import com.mrcrayfish.furniture.refurbished.inventory.RecycleBinMenu;
import com.mrcrayfish.furniture.refurbished.inventory.WorkbenchMenu;
import com.mrcrayfish.furniture.refurbished.item.PackageItem;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryResult;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageClearMessage;
import com.mrcrayfish.furniture.refurbished.network.message.MessageComputerOpenProgram;
import com.mrcrayfish.furniture.refurbished.network.message.MessageDeleteLink;
import com.mrcrayfish.furniture.refurbished.network.message.MessageHomeControl;
import com.mrcrayfish.furniture.refurbished.network.message.MessagePaddleBall;
import com.mrcrayfish.furniture.refurbished.network.message.MessageSendPackage;
import com.mrcrayfish.furniture.refurbished.network.message.MessageSetName;
import com.mrcrayfish.furniture.refurbished.network.message.MessageShowDeliveryResult;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTogglePower;
import com.mrcrayfish.furniture.refurbished.network.message.MessageUpdatePainting;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWithdrawExperience;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWorkbench;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ServerPlayHandler {
    public static void handleMessageSetName(MessageSetName message, @Nullable Player player) {
        BlockEntity blockEntity;
        if (player == null) {
            return;
        }
        Level level = player.level();
        if (level.isLoaded(message.pos()) && (blockEntity = level.getBlockEntity(message.pos())) instanceof INameable) {
            INameable nameable = (INameable)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                nameable.setName(serverPlayer, message.name().trim());
            }
        }
    }

    public static void handleMessageSendPackage(MessageSendPackage message, @Nullable Player player, MessageContext context) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
            if (abstractContainerMenu instanceof PostBoxMenu) {
                PostBoxMenu menu = (PostBoxMenu)abstractContainerMenu;
                Container container = menu.getContainer();
                if (container.isEmpty()) {
                    return;
                }
                for (int i = 0; i < container.getContainerSize(); ++i) {
                    ItemStack stack = container.getItem(i);
                    if (stack.isEmpty() || !DeliveryService.isBannedItem(stack)) continue;
                    return;
                }
                DeliveryService.get(serverPlayer.server).ifPresent(service -> {
                    ItemStack stack = PackageItem.create(container, message.message(), serverPlayer.getGameProfile().getName());
                    DeliveryResult result = service.sendMail(message.mailboxId(), stack);
                    if (result.success()) {
                        container.clearContent();
                        Network.getPlay().sendToPlayer(() -> serverPlayer, (Object)new MessageClearMessage());
                        Network.getPlay().sendToPlayer(() -> serverPlayer, (Object)new MessageShowDeliveryResult(result));
                    } else {
                        result.message().ifPresent(s -> Network.getPlay().sendToPlayer(() -> serverPlayer, (Object)new MessageShowDeliveryResult(result)));
                    }
                });
            }
        }
    }

    public static void handleMessageDeleteLink(MessageDeleteLink message, @Nullable Player player) {
        Connection c;
        Level level;
        if (player != null && player.getMainHandItem().is((Item)ModItems.WRENCH.get()) && (level = player.level()).isLoaded((c = Connection.of(message.a(), message.b())).getPosA()) && level.isLoaded(c.getPosB())) {
            Vec3 a = c.getPosA().getCenter();
            Vec3 b = c.getPosB().getCenter();
            double maxDistance = Math.max(25.0, a.distanceToSqr(b));
            if (player.distanceToSqr(a) > maxDistance && player.distanceToSqr(b) > maxDistance) {
                return;
            }
            IElectricityNode nodeA = c.getNodeA(level);
            IElectricityNode nodeB = c.getNodeB(level);
            if (nodeA != null && nodeB != null && nodeA.isConnectedToNode(nodeB)) {
                nodeA.removeNodeConnection(c);
                nodeB.removeNodeConnection(c);
            } else if (nodeA != null && nodeB == null) {
                nodeA.removeNodeConnection(c);
            } else if (nodeA == null && nodeB != null) {
                nodeB.removeNodeConnection(c);
            }
        }
    }

    public static void handleMessageToggleSwitch(MessageTogglePower message, @Nullable Player player) {
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.containerMenu) instanceof IPowerSwitchMenu) {
            IPowerSwitchMenu menu = (IPowerSwitchMenu)abstractContainerMenu;
            menu.toggle();
        }
    }

    public static void handleMessageTennisGame(MessagePaddleBall.Action message, @Nullable Player player) {
        ComputerMenu menu;
        Program program;
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.containerMenu) instanceof ComputerMenu && (program = (menu = (ComputerMenu)abstractContainerMenu).getComputer().getProgram()) instanceof PaddleBall) {
            PaddleBall game = (PaddleBall)program;
            game.update(message.action(), message.data());
        }
    }

    public static void handleMessageComputerOpenProgram(MessageComputerOpenProgram message, @Nullable Player player) {
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.containerMenu) instanceof ComputerMenu) {
            ComputerMenu menu = (ComputerMenu)abstractContainerMenu;
            menu.getComputer().launchProgram(message.id());
        }
    }

    public static void handleMessageUpdatePainting(MessageUpdatePainting message, @Nullable Player player) {
        DoorMatMenu menu;
        IPaintable paintable;
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.containerMenu) instanceof DoorMatMenu && (paintable = (menu = (DoorMatMenu)abstractContainerMenu).getPaintable()).isEditable()) {
            paintable.setImage(message.image());
            paintable.setEditable(false);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.closeContainer();
            }
        }
    }

    public static void handleMessageHomeControlToggle(MessageHomeControl.Toggle message, @Nullable Player player) {
        ComputerMenu menu;
        Program program;
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.containerMenu) instanceof ComputerMenu && (program = (menu = (ComputerMenu)abstractContainerMenu).getComputer().getProgram()) instanceof HomeControl) {
            HomeControl program2 = (HomeControl)program;
            program2.toggleDevice(message.pos());
        }
    }

    public static void handleMessageHomeControlUpdateAll(MessageHomeControl.UpdateAll message, @Nullable Player player) {
        ComputerMenu menu;
        Program program;
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.containerMenu) instanceof ComputerMenu && (program = (menu = (ComputerMenu)abstractContainerMenu).getComputer().getProgram()) instanceof HomeControl) {
            HomeControl program2 = (HomeControl)program;
            program2.updateDevices(message.state());
        }
    }

    public static void handleMessageWorkbenchSelectRecipe(MessageWorkbench.SelectRecipe message, @Nullable Player player) {
        if (player instanceof ServerPlayer) {
            WorkbenchMenu menu;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.resetLastActionTime();
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof WorkbenchMenu && (menu = (WorkbenchMenu)abstractContainerMenu).stillValid(player) && !player.isSpectator() && menu.clickMenuButton(player, message.index())) {
                menu.broadcastChanges();
            }
        }
    }

    public static void handleMessageWorkbenchSearchNeighbours(MessageWorkbench.SearchNeighbours message, @Nullable Player player) {
        if (player instanceof ServerPlayer) {
            WorkbenchMenu menu;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.resetLastActionTime();
            AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
            if (abstractContainerMenu instanceof WorkbenchMenu && (menu = (WorkbenchMenu)abstractContainerMenu).stillValid((Player)serverPlayer) && !serverPlayer.isSpectator()) {
                menu.toggleSearchNeighbours();
            }
        }
    }

    public static void handleMessageWithdrawExperience(MessageWithdrawExperience message, Player player) {
        if (player instanceof ServerPlayer) {
            Container container;
            RecycleBinMenu menu;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.resetLastActionTime();
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof RecycleBinMenu && (menu = (RecycleBinMenu)abstractContainerMenu).stillValid(player) && !player.isSpectator() && (container = menu.getContainer()) instanceof RecycleBinBlockEntity) {
                RecycleBinBlockEntity entity = (RecycleBinBlockEntity)container;
                entity.withdrawExperience(serverPlayer);
            }
        }
    }
}

