/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.item;

import com.mrcrayfish.framework.api.Environment;
import com.mrcrayfish.framework.api.util.TaskRunner;
import com.mrcrayfish.furniture.refurbished.block.FreezerBlock;
import com.mrcrayfish.furniture.refurbished.block.FridgeBlock;
import com.mrcrayfish.furniture.refurbished.block.MetalType;
import com.mrcrayfish.furniture.refurbished.item.PoweredItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;

public class FridgeItem
extends ItemNameBlockItem {
    private final FridgeBlock fridge;

    public FridgeItem(FridgeBlock fridge, FreezerBlock freezer, Item.Properties properties) {
        super((Block)freezer, properties);
        this.fridge = fridge;
    }

    public void registerBlocks(Map<Block, Item> map, Item item) {
        super.registerBlocks(map, item);
        map.put((Block)this.fridge, item);
    }

    public MetalType getMetalType() {
        return this.fridge.getMetalType();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        TaskRunner.runIf((Environment)Environment.CLIENT, () -> () -> Minecraft.getInstance().font.getSplitter().splitLines((FormattedText)PoweredItem.POWER_TOOLTIP, 150, Style.EMPTY).forEach(text -> {
            MutableComponent line = Component.empty();
            text.visit((style, s) -> {
                line.append((Component)Component.literal((String)s).withStyle(style));
                return Optional.empty();
            }, Style.EMPTY);
            lines.add((Component)line);
        }));
        super.appendHoverText(stack, context, lines, flag);
    }
}

