/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import wile.redstonepen.libmc.Networking;

public class NetworkingClient {
    public static void clientInit(PayloadRegistrar registrar) {
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void send(String packet_id, CompoundTag payload_nbt) {
        PacketDistributor.sendToServer((CustomPacketPayload)new Networking.UnifiedPayload(new Networking.UnifiedPayload.UnifiedData(packet_id, payload_nbt)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class PacketNbtNotifyClientToServer
    extends Networking.PacketNbtNotifyClientToServer {
        public static void sendToServer(CompoundTag nbt) {
            NetworkingClient.send("nnc2s", nbt);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class PacketContainerSyncClientToServer
    extends Networking.PacketContainerSyncClientToServer {
        public static void sendToServer(int container_id, CompoundTag nbt) {
            if (nbt == null) {
                return;
            }
            CompoundTag payload = new CompoundTag();
            payload.putInt("cid", container_id);
            payload.put("nbt", (Tag)nbt);
            NetworkingClient.send("csc2s", payload);
        }

        public static void sendToServer(AbstractContainerMenu container, CompoundTag nbt) {
            PacketContainerSyncClientToServer.sendToServer(container.containerId, nbt);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class PacketTileNotifyClientToServer
    extends Networking.PacketTileNotifyClientToServer {
        public static void sendToServer(BlockPos pos, CompoundTag nbt) {
            if (pos == null || nbt == null) {
                return;
            }
            CompoundTag payload = new CompoundTag();
            payload.putLong("pos", pos.asLong());
            payload.put("nbt", (Tag)nbt);
            NetworkingClient.send("tnc2s", payload);
        }

        public static void sendToServer(BlockEntity te, CompoundTag nbt) {
            if (te != null) {
                PacketTileNotifyClientToServer.sendToServer(te.getBlockPos(), nbt);
            }
        }
    }
}

