/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging.network;

import io.redspace.pvp_flagging.client.ClientHelper;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PvpFlagUpdatePacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<PvpFlagUpdatePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"pvp_flagging", (String)"pvp_flag_update"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PvpFlagUpdatePacket> STREAM_CODEC = CustomPacketPayload.codec(PvpFlagUpdatePacket::write, PvpFlagUpdatePacket::new);
    private final boolean flagged;
    private final UUID playerUUID;

    public PvpFlagUpdatePacket(UUID playerUUID, boolean flagged) {
        this.flagged = flagged;
        this.playerUUID = playerUUID;
    }

    public PvpFlagUpdatePacket(FriendlyByteBuf buf) {
        this.flagged = buf.readBoolean();
        this.playerUUID = buf.readUUID();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.flagged);
        buf.writeUUID(this.playerUUID);
    }

    public static void handle(PvpFlagUpdatePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientHelper.handlePvpFlagUpdate(packet.playerUUID, packet.flagged));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

