/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging.core;

import io.redspace.pvp_flagging.config.PvpConfig;
import io.redspace.pvp_flagging.core.PlayerFlagManager;
import io.redspace.pvp_flagging.core.PvpZone;
import io.redspace.pvp_flagging.data.PvpDataStorage;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.jetbrains.annotations.UnknownNullability;

@EventBusSubscriber(modid="pvp_flagging", bus=EventBusSubscriber.Bus.GAME)
public class PvpZoneManager
implements INBTSerializable<CompoundTag> {
    public static PvpZoneManager INSTANCE;
    private final ArrayList<PvpZone> pvpZones = new ArrayList();
    private int boundsCheckTicks = 0;

    public static void init() {
        INSTANCE = new PvpZoneManager();
    }

    public boolean addZone(PvpZone pvpZone) {
        if (!this.pvpZones.contains(pvpZone)) {
            this.pvpZones.add(pvpZone);
            PvpDataStorage.INSTANCE.setDirty();
            return true;
        }
        return false;
    }

    public boolean boundsCheckShouldWarn(Player player) {
        for (int i = 0; i < this.pvpZones.size(); ++i) {
            PvpZone zone = this.pvpZones.get(i);
            if (!zone.getBufferedZoneBounds().contains(player.position())) continue;
            return true;
        }
        return false;
    }

    public boolean boundsCheckShouldFlag(Player player) {
        for (int i = 0; i < this.pvpZones.size(); ++i) {
            PvpZone zone = this.pvpZones.get(i);
            if (!zone.contains(player.position())) continue;
            return true;
        }
        return false;
    }

    public int boundsCheckTicks() {
        if (this.boundsCheckTicks == 0) {
            this.boundsCheckTicks = (Integer)PvpConfig.SERVER.PVP_ZONE_BOUNDS_CHECK_TICKS.get();
        }
        return this.boundsCheckTicks;
    }

    public void removeZone(String name) {
        this.pvpZones.stream().filter(zone -> zone.getName().equals(name)).findFirst().ifPresent(zone -> this.pvpZones.remove(zone));
        PvpDataStorage.INSTANCE.setDirty();
    }

    public ArrayList<PvpZone> getZones() {
        return this.pvpZones;
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        ListTag pvpZonesTag = new ListTag();
        for (PvpZone pvpZone : this.pvpZones) {
            pvpZonesTag.add((Object)pvpZone.serializeNBT(null));
        }
        tag.put("pvpZones", (Tag)pvpZonesTag);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        if (nbt.contains("pvpZones")) {
            ListTag pvpZonesTag = nbt.getList("pvpZones", 10);
            pvpZonesTag.forEach(pvpZoneTag -> this.pvpZones.add(PvpZone.getPvpZone((CompoundTag)pvpZoneTag)));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player;
        MinecraftServer server;
        if (!INSTANCE.getZones().isEmpty() && (server = (player = event.getEntity()).getServer()) != null && server.overworld().getGameTime() % (long)INSTANCE.boundsCheckTicks() == 0L) {
            if (!PlayerFlagManager.INSTANCE.isPlayerFlagged(player) && INSTANCE.boundsCheckShouldFlag(player)) {
                PlayerFlagManager.INSTANCE.flagPlayer((ServerPlayer)player);
            } else if (INSTANCE.boundsCheckShouldWarn(player)) {
                PlayerFlagManager.INSTANCE.warnPlayer((ServerPlayer)player);
            }
        }
    }
}

