/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging.core;

import io.redspace.pvp_flagging.core.ZoneBounds;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public class PvpZone
implements INBTSerializable<CompoundTag> {
    private String name;
    private int buffer;
    private ZoneBounds zoneBounds;
    private ZoneBounds bufferedZoneBounds = null;

    private PvpZone() {
    }

    public PvpZone(@NotNull String name, int x1, int z1, int x2, int z2, int buffer) {
        this.zoneBounds = new ZoneBounds(x1, z1, x2, z2);
        this.name = Objects.requireNonNull(name);
        this.buffer = buffer;
    }

    public ZoneBounds getBufferedZoneBounds() {
        if (this.bufferedZoneBounds == null) {
            this.bufferedZoneBounds = this.zoneBounds.inflate(this.buffer);
        }
        return this.bufferedZoneBounds;
    }

    public ZoneBounds getBounds() {
        return this.zoneBounds;
    }

    public String getName() {
        return this.name;
    }

    boolean contains(Vec3 pos) {
        return this.zoneBounds.contains(pos.x, pos.z);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PvpZone)) return false;
        PvpZone pvpZone = (PvpZone)obj;
        if (this.name == null) return false;
        if (!this.name.equals(pvpZone.name)) return false;
        return true;
    }

    public String toString() {
        return String.format("Name:%s, Buffer:%d, %s", this.name, this.buffer, this.zoneBounds);
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putString("name", this.name);
        tag.putInt("buffer", this.buffer);
        tag.put("zoneBounds", (Tag)this.zoneBounds.serializeNBT(null));
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.name = nbt.getString("name");
        this.buffer = nbt.getInt("buffer");
        this.zoneBounds = ZoneBounds.getZoneBounds(nbt.getCompound("zoneBounds"));
    }

    public static PvpZone getPvpZone(CompoundTag nbt) {
        PvpZone pvpZone = new PvpZone();
        pvpZone.deserializeNBT(null, nbt);
        return pvpZone;
    }
}

