/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.redspace.pvp_flagging.core.PvpZone;
import io.redspace.pvp_flagging.core.PvpZoneManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class PvpZoneCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pvpZone").requires(p -> p.hasPermission(2))).then(Commands.literal((String)"add").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"x1", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"z1", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"x2", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"z2", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"buffer", (ArgumentType)IntegerArgumentType.integer()).executes(context -> PvpZoneCommand.addZone((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"x1"), IntegerArgumentType.getInteger((CommandContext)context, (String)"z1"), IntegerArgumentType.getInteger((CommandContext)context, (String)"x2"), IntegerArgumentType.getInteger((CommandContext)context, (String)"z2"), IntegerArgumentType.getInteger((CommandContext)context, (String)"buffer"))))))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> PvpZoneCommand.removeZone((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(Commands.literal((String)"list").executes(context -> PvpZoneCommand.listZones((CommandSourceStack)context.getSource()))));
    }

    private static int listZones(CommandSourceStack source) {
        if (PvpZoneManager.INSTANCE != null) {
            StringBuilder sb = new StringBuilder();
            PvpZoneManager.INSTANCE.getZones().forEach(zone -> sb.append(zone).append("\n"));
            source.sendSuccess(() -> Component.literal((String)sb.toString()), true);
        }
        return 1;
    }

    private static int addZone(CommandSourceStack source, String name, int x1, int z1, int x2, int z2, int buffer) {
        if (PvpZoneManager.INSTANCE != null) {
            PvpZone pvpZone = new PvpZone(name, x1, z1, x2, z2, buffer);
            return PvpZoneManager.INSTANCE.addZone(pvpZone) ? 1 : 0;
        }
        return 0;
    }

    private static int removeZone(CommandSourceStack source, String name) {
        if (PvpZoneManager.INSTANCE != null) {
            PvpZoneManager.INSTANCE.removeZone(name);
        }
        return 1;
    }
}

