/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging.client;

import io.redspace.pvp_flagging.PvpFlagging;
import io.redspace.pvp_flagging.util.Logging;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class ClientHelper {
    private static HashMap<UUID, Component> flaggedPlayerLookup = new HashMap();
    public static final Component nameTagIndicator = Component.translatable((String)"ui.pvp_flagging.name_tag_indicator");
    private static int unflagTimestamp = -1;

    @Nullable
    public static Component getNameTag(Player player) {
        Component newTag = null;
        if (flaggedPlayerLookup.containsKey(player.getUUID()) && (newTag = flaggedPlayerLookup.get(player.getUUID())) == null) {
            newTag = player.getDisplayName().copy().append(nameTagIndicator);
            flaggedPlayerLookup.put(player.getUUID(), newTag);
        }
        return newTag;
    }

    public static boolean isFlagged(UUID uuid) {
        return flaggedPlayerLookup.containsKey(uuid);
    }

    public static boolean isFlagged(Player player) {
        return ClientHelper.isFlagged(player.getUUID());
    }

    public static void handlePvpUnflagScheduled(int ticks) {
        if (Logging.CLIENT_PVP_FLAG_CACHE) {
            PvpFlagging.LOGGER.debug("handlePvpUnflagScheduled: ticks:{}", (Object)ticks);
        }
        if (ticks > 0) {
            Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"ui.pvp_flagging.pvp_off_scheduled", (Object[])new Object[]{ticks / 20}).withStyle(ChatFormatting.RED), false);
            if (Minecraft.getInstance().player != null) {
                unflagTimestamp = Minecraft.getInstance().player.tickCount + ticks;
            }
        }
    }

    public static void handlePvpUnflagScheduleCancelled(int ticks) {
        if (Logging.CLIENT_PVP_FLAG_CACHE) {
            PvpFlagging.LOGGER.debug("handlePvpUnflagScheduleCancelled: ticks:{}", (Object)ticks);
        }
        Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"ui.pvp_flagging.pvp_off_scheduled_cancelled").withStyle(ChatFormatting.RED), false);
        unflagTimestamp = -1;
    }

    public static int getUnflagTimestamp() {
        return unflagTimestamp;
    }

    public static void resetUnflagTimestamp() {
        unflagTimestamp = -1;
    }

    public static void handlePvpZoneWarning() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (Logging.CLIENT_PVP_FLAG_CACHE) {
            PvpFlagging.LOGGER.debug("handlePvpZoneWarning player:{}", (Object)player);
        }
        if (player != null && ClientHelper.isFlagged((Player)player)) {
            Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"ui.pvp_flagging.pvp_zone.entry_warning.flagged").withStyle(ChatFormatting.RED), false);
        } else {
            Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"ui.pvp_flagging.pvp_zone.entry_warning.unflagged").withStyle(ChatFormatting.RED), false);
        }
    }

    public static void handlePvpFlagUpdate(UUID playerUUID, boolean isFlagged) {
        LocalPlayer player;
        if (Logging.CLIENT_PVP_FLAG_CACHE) {
            PvpFlagging.LOGGER.debug("handlePvpFlagUpdate: playerUUID:{}, isFlagged:{}", (Object)playerUUID, (Object)isFlagged);
        }
        if ((player = Minecraft.getInstance().player) != null && playerUUID.equals(player.getUUID())) {
            if (isFlagged) {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"ui.pvp_flagging.pvp_on").withStyle(ChatFormatting.RED), false);
            } else {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"ui.pvp_flagging.pvp_off").withStyle(ChatFormatting.RED), false);
            }
        }
        if (isFlagged) {
            flaggedPlayerLookup.put(playerUUID, null);
        } else {
            flaggedPlayerLookup.remove(playerUUID);
        }
    }

    public static void handleFullPvpDataSync(ObjectSet<UUID> flaggedPlayers) {
        if (Logging.CLIENT_PVP_FLAG_CACHE) {
            PvpFlagging.LOGGER.debug("handleFullPvpDataSync: size:{}", (Object)flaggedPlayers.size());
        }
        HashMap tmp = new HashMap();
        flaggedPlayers.forEach(k -> tmp.put(k, null));
        flaggedPlayerLookup = tmp;
        unflagTimestamp = -1;
    }
}

