/*
 * Decompiled with CFR 0.152.
 */
package mod.icanttellyou.picturemode.value;

import mod.icanttellyou.picturemode.util.Tickable;
import mod.icanttellyou.picturemode.value.Easing;
import mod.icanttellyou.picturemode.value.Value;
import net.minecraft.util.Mth;

public class InterpolatedValue
implements Value,
Tickable {
    private final double duration;
    private final Easing easing;
    private double goal;
    private double start;
    private int progress;

    public InterpolatedValue(Easing easing, double duration) {
        this(easing, 0.0, duration);
    }

    public InterpolatedValue(Easing easing, double def, double duration) {
        if (duration == 0.0) {
            throw new IllegalArgumentException("Cannot use duration of 0! Please use StaticValue instead!");
        }
        this.easing = easing;
        this.progress = (int)Math.ceil(duration);
        this.duration = duration;
        this.setValue(def);
    }

    @Override
    public void setGoal(double goal) {
        this.setGoal(goal, 0.0);
    }

    @Override
    public void setGoal(double goal, double delta) {
        this.start = (double)this.progress >= this.duration ? this.goal : this.getValue(delta);
        this.goal = goal;
        this.progress = 0;
    }

    @Override
    public void addToGoal(double add) {
        this.addToGoal(add, 0.0);
    }

    @Override
    public void addToGoal(double add, double delta) {
        this.start = (double)this.progress >= this.duration ? this.goal : this.getValue(delta);
        this.goal += add;
        this.progress = 0;
    }

    @Override
    public void subtractFromGoal(double subtract) {
        this.subtractFromGoal(subtract, 0.0);
    }

    @Override
    public void subtractFromGoal(double subtract, double delta) {
        this.start = (double)this.progress >= this.duration ? this.goal : this.getValue(delta);
        this.goal -= subtract;
        this.progress = 0;
    }

    @Override
    public void setValue(double value) {
        this.goal = value;
        this.start = value;
        this.progress = (int)this.duration;
    }

    @Override
    public double getGoal() {
        return this.goal;
    }

    @Override
    public double getValue(double delta) {
        double position = Mth.clamp((double)(((double)this.progress + delta) / this.duration), (double)0.0, (double)1.0);
        return this.easing.apply(position, this.start, this.goal);
    }

    @Override
    public boolean onTick() {
        if ((double)this.progress < this.duration) {
            ++this.progress;
        }
        return true;
    }
}

