/*
 * Decompiled with CFR 0.152.
 */
package mod.icanttellyou.picturemode.value;

import mod.icanttellyou.picturemode.util.Tickable;
import mod.icanttellyou.picturemode.value.Value;
import net.minecraft.util.Mth;

public record ClampedValue(Value base, double min, double max) implements Value,
Tickable
{
    @Override
    public void setGoal(double goal) {
        this.setGoal(goal, 0.0);
    }

    @Override
    public void setGoal(double goal, double delta) {
        this.base.setGoal(Mth.clamp((double)goal, (double)this.min, (double)this.max), delta);
    }

    @Override
    public void addToGoal(double add) {
        this.addToGoal(add, 0.0);
    }

    @Override
    public void addToGoal(double add, double delta) {
        double goal = this.base.getGoal();
        double added = goal + add;
        double clamped = added > this.max ? add - (added - this.max) : (added < this.min ? add - (this.min - added) : add);
        this.base.addToGoal(clamped, delta);
    }

    @Override
    public void subtractFromGoal(double subtract) {
        this.subtractFromGoal(subtract, 0.0);
    }

    @Override
    public void subtractFromGoal(double subtract, double delta) {
        double goal = this.base.getGoal();
        double subtracted = goal - subtract;
        double clamped = subtracted > this.max ? subtract - (subtracted - this.max) : (subtracted < this.min ? subtract - (this.min - subtracted) : subtract);
        this.base.subtractFromGoal(clamped, delta);
    }

    @Override
    public void setValue(double value) {
        this.base.setValue(value);
    }

    @Override
    public double getGoal() {
        return this.base.getGoal();
    }

    @Override
    public double getValue(double delta) {
        return this.base.getValue(delta);
    }

    @Override
    public boolean onTick() {
        Value value = this.base;
        if (value instanceof Tickable) {
            Tickable tickable = (Tickable)((Object)value);
            return tickable.onTick();
        }
        return false;
    }
}

