/*
 * Decompiled with CFR 0.152.
 */
package mod.icanttellyou.picturemode.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class LoggingUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Picture Mode");

    public static void log(Level level, String message, Object ... args) {
        String template = "[Picture Mode] " + message;
        switch (level) {
            case TRACE: {
                LOGGER.trace(template, args);
                break;
            }
            case DEBUG: {
                LOGGER.debug(template, args);
                break;
            }
            case INFO: {
                LOGGER.info(template, args);
                break;
            }
            case WARN: {
                LOGGER.warn(template, args);
                break;
            }
            case ERROR: {
                LOGGER.error(template, args);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown logging level: " + String.valueOf(level));
            }
        }
    }

    public static void log(String message) {
        LoggingUtil.log(Level.INFO, message, new Object[0]);
    }
}

