/*
 * Decompiled with CFR 0.152.
 */
package mod.icanttellyou.picturemode.mixin;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import mod.icanttellyou.picturemode.client.PictureModeClient;
import mod.icanttellyou.picturemode.client.PictureModeState;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Shadow
    public abstract float getDepthFar();

    @Inject(method={"getFov"}, at={@At(value="HEAD")}, cancellable=true)
    private void replaceFOVWithDeltaTicks(Camera camera, float partialTick, boolean useFovSetting, CallbackInfoReturnable<Double> cir) {
        PictureModeState state = PictureModeClient.getState();
        if (state != null && state.isEnabled()) {
            cir.setReturnValue((Object)partialTick);
        }
    }

    @Inject(method={"getProjectionMatrix"}, at={@At(value="HEAD")}, cancellable=true)
    private void setupPMMatrices(double fov, CallbackInfoReturnable<Matrix4f> cir) {
        PictureModeState state = PictureModeClient.getState();
        if (state == null || !state.isEnabled()) {
            return;
        }
        int width = this.minecraft.getWindow().getWidth();
        int height = this.minecraft.getWindow().getHeight();
        float farPlane = this.getDepthFar();
        cir.setReturnValue((Object)state.getProjectionMatrix(width, height, farPlane, fov));
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Ljava/lang/Math;max(DD)D", remap=false)})
    private double bypassFOVComparisonInPM(double a, double b, Operation<Double> original) {
        PictureModeState state = PictureModeClient.getState();
        if (state != null && state.isEnabled()) {
            return a;
        }
        return (Double)original.call(new Object[]{a, b});
    }

    @Inject(method={"bobView", "bobHurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelBobbingInPM(CallbackInfo ci) {
        PictureModeState state = PictureModeClient.getState();
        if (state != null && state.isEnabled()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderItemInHand"}, at={@At(value="HEAD")}, cancellable=true)
    private void hideHandInPM(CallbackInfo ci) {
        PictureModeState state = PictureModeClient.getState();
        if (state != null && state.isEnabled()) {
            ci.cancel();
        }
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="MIXINEXTRAS:EXPRESSION", ordinal=1)})
    @Definition(id="renderLevel", local={@Local(type=boolean.class, ordinal=0, argsOnly=true)})
    @Expression(value={"renderLevel"})
    private boolean hideHudInPM(boolean original) {
        PictureModeState state = PictureModeClient.getState();
        if (state == null) {
            return original;
        }
        return !state.isEnabled() && original;
    }
}

