/*
 * Decompiled with CFR 0.152.
 */
package mod.icanttellyou.picturemode.client.gui.widget;

import java.util.function.Consumer;
import mod.icanttellyou.picturemode.util.Tickable;
import mod.icanttellyou.picturemode.value.Easing;
import mod.icanttellyou.picturemode.value.InterpolatedValue;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractStringWidget;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class FadingStringWidget
extends AbstractStringWidget
implements Tickable {
    private static final int TEXT_MARGIN = 2;
    private int maxWidth = 0;
    private int cachedWidth = 0;
    private boolean cachedWidthDirty = true;
    private TextOverflow textOverflow = TextOverflow.CLAMPED;
    private final InterpolatedValue alphaFade = new InterpolatedValue(Easing.LINEAR, 1.0, 10.0);
    private boolean wasMouseOver = false;
    private boolean haltFading;
    private final int defaultTicksUntilFade;
    private int ticksUntilFade;
    @Nullable
    private Consumer<Style> componentClickHandler = null;

    public FadingStringWidget(int x, int y, int width, int height, Component message, Font font, int ticksUntilFade, boolean haltFading) {
        super(x, y, width, height, message, font);
        this.defaultTicksUntilFade = ticksUntilFade;
        this.ticksUntilFade = ticksUntilFade;
        this.haltFading = haltFading;
    }

    public FadingStringWidget(int width, int height, Component message, Font font, int ticksUntilFade, boolean haltFading) {
        this(0, 0, width, height, message, font, ticksUntilFade, haltFading);
    }

    public FadingStringWidget(Component message, Font font, int ticksUntilFade, boolean haltFading) {
        this(0, 0, font.width(message.getVisualOrderText()), 9, message, font, ticksUntilFade, haltFading);
    }

    public void setMessage(Component message) {
        super.setMessage(message);
        this.setWidth(this.getFont().width(message.getVisualOrderText()));
        this.cachedWidthDirty = true;
        this.haltFading = false;
        this.resetFade();
    }

    public FadingStringWidget setMaxWidth(int maxWidth) {
        return this.setMaxWidth(maxWidth, TextOverflow.CLAMPED);
    }

    public FadingStringWidget setMaxWidth(int maxWidth, TextOverflow textOverflow) {
        this.maxWidth = maxWidth;
        this.textOverflow = textOverflow;
        return this;
    }

    private void resetFade() {
        if (this.haltFading) {
            return;
        }
        this.visible = true;
        this.alphaFade.setValue(1.0);
        this.ticksUntilFade = this.defaultTicksUntilFade;
    }

    public void fadeOut() {
        this.haltFading = false;
        this.alphaFade.setGoal(0.0);
        this.ticksUntilFade = -1;
    }

    public int getWidth() {
        if (this.maxWidth > 0) {
            if (this.cachedWidthDirty) {
                this.cachedWidth = Math.min(this.maxWidth, this.getFont().width(this.getMessage().getVisualOrderText()));
                this.cachedWidthDirty = false;
            }
            return this.cachedWidth;
        }
        return super.getWidth();
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks) {
        double fade = this.alphaFade.getValue(deltaTicks);
        if (fade == 0.0) {
            this.visible = false;
            return;
        }
        if (this.isMouseOver(mouseX, mouseY)) {
            this.resetFade();
            this.haltFading = true;
            this.wasMouseOver = true;
        } else if (this.wasMouseOver) {
            this.haltFading = false;
            this.wasMouseOver = false;
        }
        this.renderText(graphics, fade);
    }

    public void renderText(GuiGraphics graphics, double alpha) {
        Component message = this.getMessage();
        Font font = this.getFont();
        int maxWidth = this.maxWidth > 0 ? this.maxWidth : this.getWidth();
        int textWidth = font.width((FormattedText)message);
        int x = this.getX();
        int y = this.getY() + (this.getHeight() - 9) / 2;
        if (alpha == 0.0) {
            return;
        }
        int textColor = Mth.floor((double)(alpha * 255.0)) << 24 | 0xFFFFFF;
        if (textWidth > maxWidth) {
            switch (this.textOverflow.ordinal()) {
                case 0: {
                    graphics.drawString(font, FadingStringWidget.clipText(message, font, maxWidth), x, y, textColor);
                    break;
                }
                case 1: {
                    int minX = x + 2;
                    int maxX = x + maxWidth - 2;
                    int minY = this.getY();
                    int maxY = this.getY() + this.getHeight();
                    FadingStringWidget.renderScrollingString((GuiGraphics)graphics, (Font)font, (Component)message, (int)minX, (int)minY, (int)maxX, (int)maxY, (int)textColor);
                }
            }
        } else {
            graphics.drawString(font, message.getVisualOrderText(), x, y, textColor);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible || !this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        Component message = this.getMessage();
        Font font = this.getFont();
        Style style = font.getSplitter().componentStyleAtWidth((FormattedText)message, Mth.floor((double)(mouseX - (double)this.getX())));
        if (style != null && this.componentClickHandler != null) {
            this.componentClickHandler.accept(style);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void setComponentClickHandler(@Nullable Consumer<Style> componentClickHandler) {
        this.componentClickHandler = componentClickHandler;
    }

    public void playDownSound(SoundManager o) {
    }

    public static FormattedCharSequence clipText(Component component, Font font, int width) {
        FormattedText formattedText = font.substrByWidth((FormattedText)component, width - font.width((FormattedText)CommonComponents.ELLIPSIS));
        return Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{formattedText, CommonComponents.ELLIPSIS}));
    }

    @Override
    public boolean onTick() {
        if (this.haltFading) {
            return true;
        }
        if (this.ticksUntilFade > 0) {
            --this.ticksUntilFade;
            return true;
        }
        if (this.ticksUntilFade == 0) {
            this.alphaFade.setGoal(0.0);
            this.ticksUntilFade = -1;
        }
        return this.alphaFade.onTick();
    }

    public static enum TextOverflow {
        CLAMPED,
        SCROLLING;

    }
}

