/*
 * Decompiled with CFR 0.152.
 */
package mod.icanttellyou.picturemode.client.gui.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.layouts.AbstractLayout;
import net.minecraft.client.gui.layouts.LayoutElement;

public class AnchorLayout
extends AbstractLayout {
    private final List<Child> children = new ArrayList<Child>();

    public AnchorLayout(int x, int y) {
        super(x, y, 0, 0);
    }

    public <T extends LayoutElement> T addChild(Position pos, T child) {
        this.children.add(new Child(child, pos));
        return child;
    }

    public void arrangeElements() {
        super.arrangeElements();
        for (Child child : this.children) {
            LayoutElement element = child.element;
            int x = this.getX() + Math.round(child.pos.xPos * (float)(this.width - element.getWidth()));
            int y = this.getY() + Math.round(child.pos.yPos * (float)(this.height - element.getHeight()));
            element.setX(x);
            element.setY(y);
        }
    }

    public void visitChildren(Consumer<LayoutElement> visitor) {
        this.children.forEach(child -> visitor.accept(child.element));
    }

    public void updateDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    private record Child(LayoutElement element, Position pos) {
    }

    public static enum Position {
        TOP_LEFT(0.0f, 0.0f),
        TOP_CENTER(0.0f, 0.5f),
        TOP_RIGHT(0.0f, 1.0f),
        MIDDLE_LEFT(0.5f, 0.0f),
        MIDDLE_CENTER(0.5f, 0.5f),
        MIDDLE_RIGHT(0.5f, 1.0f),
        BOTTOM_LEFT(1.0f, 0.0f),
        BOTTOM_CENTER(1.0f, 0.5f),
        BOTTOM_RIGHT(1.0f, 1.0f);

        private final float xPos;
        private final float yPos;

        private Position(float yPos, float xPos) {
            this.xPos = xPos;
            this.yPos = yPos;
        }

        public float getXPos() {
            return this.xPos;
        }

        public float getYPos() {
            return this.yPos;
        }
    }
}

