/*
 * Decompiled with CFR 0.152.
 */
package mod.icanttellyou.picturemode.client.gui;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import java.io.File;
import mod.icanttellyou.picturemode.client.PictureModeClient;
import mod.icanttellyou.picturemode.client.PictureModeState;
import mod.icanttellyou.picturemode.client.gui.layout.AnchorLayout;
import mod.icanttellyou.picturemode.client.gui.widget.FadingStringWidget;
import mod.icanttellyou.picturemode.client.gui.widget.Slider;
import mod.icanttellyou.picturemode.util.LevelUtils;
import mod.icanttellyou.picturemode.util.Tickable;
import net.minecraft.Util;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class PictureModeScreen
extends Screen {
    private static final String DEFAULT_KEY = "gui.picturemode.default";
    private static final String DEGREES_KEY = "gui.picturemode.degrees";
    private static final String CENTER_CAMERA_KEY = "gui.picturemode.centerCamera";
    private static final String SHOW_PLAYER_KEY = "gui.picturemode.showPlayer";
    private static final String TIME_KEY = "gui.picturemode.time";
    private static final String FOG_KEY = "gui.picturemode.fog";
    private static final String TILT_KEY = "gui.picturemode.tilt";
    private static final String TAKE_SCREENSHOT_KEY = "gui.picturemode.takeScreenshot";
    private static final String HELP_TEXT_KEY = "gui.picturemode.helpText";
    private boolean isTakingScreenshot;
    private final PictureModeState pmState;
    private final Screen parent;
    private final AnchorLayout layout;
    private FadingStringWidget helpText;
    private Button centerCameraButton;
    private final long openedAtMillis;
    private double cameraPanXStart;
    private double cameraPanYStart;
    private double cameraRotationStart;
    private double mouseXStart;
    private double mouseYStart;

    public PictureModeScreen(Screen parent, Component title) {
        super(title);
        this.parent = parent;
        this.pmState = PictureModeClient.getState();
        this.layout = new AnchorLayout(0, 0);
        this.openedAtMillis = Util.getMillis();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        boolean bl = this.centerCameraButton.active = !(this.pmState.cameraPanX.getValue(partialTick) == 0.0 && this.pmState.cameraPanY.getValue(partialTick) == 0.0 || this.pmState.cameraPanX.getGoal() == 0.0 && this.pmState.cameraPanY.getGoal() == 0.0);
        if (!this.isTakingScreenshot) {
            super.render(graphics, mouseX, mouseY, partialTick);
        } else {
            Screenshot.grab((File)this.minecraft.gameDirectory, (RenderTarget)this.minecraft.getMainRenderTarget(), message -> {
                this.helpText.setMessage((Component)message);
                this.repositionElements();
            });
            this.isTakingScreenshot = false;
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void init() {
        super.init();
        this.pmState.resetState();
        this.pmState.setEnabled(true);
        Button closeButton = Button.builder((Component)Component.literal((String)"X"), button -> this.minecraft.setScreen(this.parent)).width(20).build();
        this.layout.addChild(AnchorLayout.Position.TOP_LEFT, closeButton);
        GridLayout options = this.makeOptions();
        this.layout.addChild(AnchorLayout.Position.TOP_RIGHT, options);
        GridLayout actions = this.makeActions();
        this.layout.addChild(AnchorLayout.Position.BOTTOM_CENTER, actions);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    private GridLayout makeOptions() {
        GridLayout layout = new GridLayout();
        layout.defaultCellSetting().paddingBottom(1);
        GridLayout.RowHelper rows = layout.createRowHelper(1);
        this.centerCameraButton = Button.builder((Component)Component.translatable((String)CENTER_CAMERA_KEY), button -> {
            this.pmState.cameraPanX.setGoal(0.0, this.getDeltaTicks());
            this.pmState.cameraPanY.setGoal(0.0, this.getDeltaTicks());
        }).build();
        rows.addChild((LayoutElement)this.centerCameraButton);
        rows.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)SHOW_PLAYER_KEY, (Object[])new Object[]{CommonComponents.optionStatus((boolean)this.pmState.isPlayerShown())}), button -> {
            this.pmState.togglePlayerShown();
            button.setMessage((Component)Component.translatable((String)SHOW_PLAYER_KEY, (Object[])new Object[]{CommonComponents.optionStatus((boolean)this.pmState.isPlayerShown())}));
        }).build());
        rows.addChild((LayoutElement)new Slider(0, 0, 0.3333333333333333, (slider, value, messageUpdate) -> {
            if (!messageUpdate) {
                this.pmState.cameraTilt.setGoal(value * 90.0, this.getDeltaTicks());
            } else {
                int degrees = (int)(value * 90.0);
                slider.setMessage((Component)Component.translatable((String)TILT_KEY, (Object[])new Object[]{(double)degrees == 30.0 ? Component.translatable((String)DEFAULT_KEY) : Component.translatable((String)DEGREES_KEY, (Object[])new Object[]{degrees})}));
            }
        }));
        if (this.minecraft.isSingleplayer()) {
            rows.addChild((LayoutElement)new Slider(0, 0, 0.0, (slider, value, messageUpdate) -> {
                assert (this.minecraft.level != null);
                int dayLength = LevelUtils.getDayLength((Level)this.minecraft.level);
                if (!messageUpdate) {
                    this.pmState.timeOverride.setGoal(value * (double)dayLength);
                } else {
                    int ticks = (int)(value * (double)dayLength);
                    slider.setMessage((Component)Component.translatable((String)TIME_KEY, (Object[])new Object[]{ticks == 0 ? Component.translatable((String)DEFAULT_KEY) : Component.literal((String)String.valueOf(ticks))}));
                }
            }));
            rows.addChild((LayoutElement)new Slider(0, 0, 1.0, (slider, value, messageUpdate) -> {
                if (!messageUpdate) {
                    this.pmState.fog.setGoal(Math.pow(2.0, 8.0 * value - 8.0), this.getDeltaTicks());
                } else {
                    int percent = (int)(value * 100.0);
                    slider.setMessage((Component)Component.translatable((String)FOG_KEY, (Object[])new Object[]{percent}));
                }
            }));
        }
        return layout;
    }

    private GridLayout makeActions() {
        GridLayout layout = new GridLayout();
        layout.defaultCellSetting().alignHorizontallyCenter();
        GridLayout actions = new GridLayout();
        actions.defaultCellSetting().alignHorizontallyCenter().paddingHorizontal(1);
        GridLayout.RowHelper columns = layout.createRowHelper(1);
        GridLayout.RowHelper rows = actions.createRowHelper(3);
        this.helpText = new FadingStringWidget((Component)Component.translatable((String)HELP_TEXT_KEY), this.font, 100, true);
        this.helpText.setComponentClickHandler(arg_0 -> ((PictureModeScreen)this).handleComponentClicked(arg_0));
        columns.addChild((LayoutElement)this.helpText, rows.newCellSettings().paddingBottom(12));
        rows.addChild((LayoutElement)Button.builder((Component)Component.literal((String)"<"), button -> this.pmState.cameraRotation.addToGoal(45.0, this.getDeltaTicks())).width(20).build());
        rows.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)TAKE_SCREENSHOT_KEY), button -> {
            this.isTakingScreenshot = true;
        }).width(98).build());
        rows.addChild((LayoutElement)Button.builder((Component)Component.literal((String)">"), button -> this.pmState.cameraRotation.subtractFromGoal(45.0, this.getDeltaTicks())).width(20).build());
        columns.addChild((LayoutElement)actions);
        return layout;
    }

    protected void repositionElements() {
        this.layout.updateDimensions(this.width, this.height);
        this.layout.arrangeElements();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY < 0.0) {
            this.pmState.cameraZoom.subtractFromGoal(0.25, this.getDeltaTicks());
        } else if (scrollY > 0.0) {
            this.pmState.cameraZoom.addToGoal(0.25, this.getDeltaTicks());
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        float delta = this.getDeltaTicks();
        if (!super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            if (this.openedAtMillis + 250L >= Util.getMillis()) {
                return true;
            }
            Window window = this.minecraft.getWindow();
            mouseX *= (double)window.getScreenWidth() / (double)window.getGuiScaledWidth();
            mouseY *= (double)window.getScreenHeight() / (double)window.getGuiScaledHeight();
            if (button == 0) {
                double zoom = this.pmState.cameraZoom.getValue(this.getDeltaTicks());
                double div = Math.pow(2.0, zoom) / 3.0;
                this.pmState.cameraPanX.setGoal(this.cameraPanXStart + (mouseX - this.mouseXStart) / div, delta);
                this.pmState.cameraPanY.setGoal(this.cameraPanYStart + (mouseY - this.mouseYStart) / div, delta);
            } else {
                this.pmState.cameraRotation.setGoal(this.cameraRotationStart + (mouseX - this.mouseXStart) * 0.3515625, delta);
            }
        }
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!super.mouseClicked(mouseX, mouseY, button)) {
            Window window = this.minecraft.getWindow();
            this.mouseXStart = mouseX *= (double)window.getScreenWidth() / (double)window.getGuiScaledWidth();
            this.mouseYStart = mouseY *= (double)window.getScreenHeight() / (double)window.getGuiScaledHeight();
            float delta = this.getDeltaTicks();
            this.cameraPanXStart = this.pmState.cameraPanX.getValue(delta);
            this.cameraPanYStart = this.pmState.cameraPanY.getValue(delta);
            this.cameraRotationStart = this.pmState.cameraRotation.getValue(delta);
            this.helpText.fadeOut();
        }
        return true;
    }

    public void removed() {
        this.pmState.setEnabled(false);
    }

    public void tick() {
        for (GuiEventListener eventListener : this.children()) {
            if (!(eventListener instanceof Tickable)) continue;
            Tickable tickable = (Tickable)eventListener;
            tickable.onTick();
        }
    }

    public void onClose() {
        this.pmState.setEnabled(false);
        super.onClose();
    }

    private float getDeltaTicks() {
        return this.minecraft.getTimer().getGameTimeDeltaPartialTick(true);
    }
}

