/*
 * Decompiled with CFR 0.152.
 */
package mod.icanttellyou.picturemode.client;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mod.icanttellyou.picturemode.util.LoggingUtil;
import mod.icanttellyou.picturemode.util.Tickable;
import mod.icanttellyou.picturemode.value.Easing;
import mod.icanttellyou.picturemode.value.InterpolatedValue;
import mod.icanttellyou.picturemode.value.StaticValue;
import mod.icanttellyou.picturemode.value.Value;
import org.joml.Matrix4f;
import org.slf4j.event.Level;

public class PictureModeState {
    private boolean enabled = false;
    public final Value cameraRotation = new InterpolatedValue(Easing.EXPONENTIAL, 45.0, 25.0);
    public final Value cameraTilt = new InterpolatedValue(Easing.EXPONENTIAL, 30.0, 25.0);
    public final Value cameraZoom = new InterpolatedValue(Easing.EXPONENTIAL, 1.0, 25.0).clamped(0.0, Double.MAX_VALUE);
    public final Value fog = new InterpolatedValue(Easing.EXPONENTIAL, 1.0, 100.0);
    public final Value cameraPanX = new InterpolatedValue(Easing.EXPONENTIAL, 5.0);
    public final Value cameraPanY = new InterpolatedValue(Easing.EXPONENTIAL, 5.0);
    public final Value timeOverride = new StaticValue();
    private boolean showPlayer = true;
    private final List<Tickable> tickingCallbacks = new ArrayList<Tickable>();

    public PictureModeState() {
        this.addTickableCallbacks(this.getClass(), this);
    }

    public Matrix4f getProjectionMatrix(int width, int height, float farPlane, double delta) {
        float viewWidth = (float)this.adjustViewportDimension(width, delta);
        float viewHeight = (float)this.adjustViewportDimension(height, delta);
        float panX = (float)this.cameraPanX.getValue(delta);
        float panY = (float)this.cameraPanY.getValue(delta);
        return new Matrix4f().setOrtho(-viewWidth, viewWidth, -viewHeight, viewHeight, -farPlane * 2.0f, farPlane * 2.0f).translate(panX, -panY, 0.0f);
    }

    public double adjustViewportDimension(int baseDimension, double delta) {
        double zoom = this.cameraZoom.getValue(delta);
        double expZoom = Math.pow(2.0, zoom);
        return (double)baseDimension / expZoom;
    }

    public void setupCameraAngles(double delta, AngleSetter angleSetter) {
        float yaw = (float)this.cameraRotation.getValue(delta);
        float pitch = (float)this.cameraTilt.getValue(delta);
        angleSetter.setAngles(yaw, pitch);
    }

    public boolean isPlayerShown() {
        return this.showPlayer;
    }

    public void togglePlayerShown() {
        this.showPlayer = !this.showPlayer;
    }

    public void tick() {
        Iterator<Tickable> iterator = this.tickingCallbacks.iterator();
        while (iterator.hasNext()) {
            Tickable tickable = iterator.next();
            boolean contTick = tickable.onTick();
            if (contTick) continue;
            iterator.remove();
        }
    }

    public void resetState() {
        this.cameraRotation.setValue(45.0);
        this.cameraTilt.setValue(30.0);
        this.cameraZoom.setValue(1.0);
        this.fog.setValue(1.0);
        this.cameraPanX.setValue(0.0);
        this.cameraPanY.setValue(0.0);
        this.showPlayer = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void addTickableCallback(Tickable tickable) {
        this.tickingCallbacks.add(tickable);
    }

    public void addTickableCallbacks(Class<?> clazz, Object instance) {
        try {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Object value;
                if (!field.getType().isAssignableFrom(Value.class)) continue;
                boolean accessible = field.canAccess(instance);
                if (!accessible) {
                    field.setAccessible(true);
                }
                if ((value = field.get(instance)) instanceof Tickable) {
                    Tickable tickable = (Tickable)value;
                    this.addTickableCallback(tickable);
                }
                if (accessible) continue;
                field.setAccessible(false);
            }
        }
        catch (Exception e) {
            LoggingUtil.log(Level.ERROR, "Failed to add ticking callbacks for class {}!", clazz.getName(), e);
        }
    }

    @FunctionalInterface
    public static interface AngleSetter {
        public void setAngles(float var1, float var2);
    }
}

