/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particle_effects.manager;

import com.leclowndu93150.particle_effects.ParticleEffects;
import com.leclowndu93150.particle_effects.config.ParticleEffectsConfig;
import com.leclowndu93150.particle_effects.particle.TexturedParticleFactory;
import com.leclowndu93150.particle_effects.utils.ArgbUtils;
import com.leclowndu93150.particle_effects.utils.ListUtils;
import com.leclowndu93150.particle_effects.utils.PEStatusEffect;
import com.leclowndu93150.particle_effects.utils.PEType;
import com.leclowndu93150.particle_effects.utils.StatusEffectUtils;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Stream;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public class ParticleEffectsManager {
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)"particle_effects");
    private static final Map<String, DeferredHolder<ParticleType<?>, SimpleParticleType>> REGISTERED_PARTICLES = new HashMap();
    private static final Map<MobEffect, DeferredHolder<ParticleType<?>, SimpleParticleType>> EFFECT_TO_PARTICLE = new HashMap();
    private static final Map<Integer, List<ParticleOptions>> COLOR_TO_PARTICLES_MAP = new HashMap<Integer, List<ParticleOptions>>();
    private static final HashMap<ParticleOptions, MobEffect> MINECRAFT_EFFECTS_WITH_TEXTURED_PARTICLE = ParticleEffectsManager.getMinecraftEffectWidthTexturedParticles();

    @Nullable
    public static List<ParticleOptions> getParticleEffects(Integer i) {
        return COLOR_TO_PARTICLES_MAP.get(i);
    }

    private static DeferredHolder<ParticleType<?>, SimpleParticleType> registerParticleTypeForEffect(MobEffect statusEffect, ResourceLocation effectId) {
        ResourceLocation modEffectId = ParticleEffectsManager.getModEffectId(statusEffect, effectId);
        String registryName = modEffectId.getPath();
        DeferredHolder holder = PARTICLES.register(registryName, () -> new SimpleParticleType(false));
        REGISTERED_PARTICLES.put(registryName, holder);
        return holder;
    }

    private static ResourceLocation getModEffectId(MobEffect statusEffect, ResourceLocation effectId) {
        boolean bl = MINECRAFT_EFFECTS_WITH_TEXTURED_PARTICLE.containsValue(statusEffect);
        return ParticleEffects.id(effectId.getPath() + (bl ? "_new" : ""));
    }

    public static void onInitialize() {
        for (Holder.Reference reference : BuiltInRegistries.MOB_EFFECT.holders().toList()) {
            MobEffect statusEffect = (MobEffect)reference.value();
            ResourceLocation id = reference.key().location();
            if (!id.getNamespace().equals("minecraft")) continue;
            DeferredHolder<ParticleType<?>, SimpleParticleType> holder = ParticleEffectsManager.registerParticleTypeForEffect(statusEffect, id);
            EFFECT_TO_PARTICLE.put(statusEffect, holder);
        }
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ResourceLocation id;
            for (Map.Entry<MobEffect, DeferredHolder<ParticleType<?>, SimpleParticleType>> entry : EFFECT_TO_PARTICLE.entrySet()) {
                StatusEffectUtils.swapParticle(entry.getKey(), (ParticleOptions)entry.getValue().get());
            }
            for (Holder.Reference reference : BuiltInRegistries.POTION.holders().toList()) {
                List effects;
                OptionalInt optional;
                Potion potion = (Potion)reference.value();
                id = reference.key().location();
                if (!id.getNamespace().equals("minecraft") || (optional = PotionContents.getColorOptional((Iterable)(effects = potion.getEffects()))).isEmpty()) continue;
                int color = ArgbUtils.getColorWithoutAlpha(optional.getAsInt());
                List particleEffects = effects.stream().map(MobEffectInstance::getEffect).map(Holder::value).flatMap(effect -> {
                    ParticleOptions particleEffect = ((PEStatusEffect)effect).particleEffects$getParticleEffect();
                    if (particleEffect == null) {
                        ParticleEffects.LOGGER.error("[DEV/Potion Registration] Looks like {} effect with color {} doesn't have textured particle, this shouldn't happen! Skipping it registration.", (Object)color, (Object)effect.getDisplayName().getString());
                        return Stream.empty();
                    }
                    return Stream.of(particleEffect);
                }).toList();
                COLOR_TO_PARTICLES_MAP.put(color, particleEffects);
            }
            for (Holder.Reference reference : BuiltInRegistries.MOB_EFFECT.holders().toList()) {
                MobEffect statusEffect = (MobEffect)reference.value();
                id = reference.key().location();
                if (!id.getNamespace().equals("minecraft")) continue;
                int color = ArgbUtils.getColorWithoutAlpha(statusEffect.getColor());
                ParticleOptions particleEffect = ((PEStatusEffect)statusEffect).particleEffects$getParticleEffect();
                if (particleEffect == null) {
                    ParticleEffects.LOGGER.error("[DEV/Effect Registration] Looks like {} effect with color {} doesn't have textured particle, this shouldn't happen! Skipping it registration.", (Object)color, (Object)statusEffect.getDisplayName().getString());
                    continue;
                }
                List<ParticleOptions> effects = COLOR_TO_PARTICLES_MAP.get(color);
                if (effects != null) {
                    if (!((Boolean)ParticleEffectsConfig.CLIENT.debugLogEnabled.get()).booleanValue()) continue;
                    ParticleEffects.LOGGER.warn("[DEV/Effect Registration] Found registered effects for color {} from {} effect, skipping it registration. If you just mod user, ignore it.", (Object)color, (Object)statusEffect.getDisplayName().getString());
                    continue;
                }
                COLOR_TO_PARTICLES_MAP.put(color, List.of(particleEffect));
            }
        });
    }

    @SubscribeEvent
    public static void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
        for (DeferredHolder<ParticleType<?>, SimpleParticleType> holder : REGISTERED_PARTICLES.values()) {
            event.registerSpriteSet((ParticleType)holder.get(), TexturedParticleFactory::new);
        }
    }

    private static HashMap<ParticleOptions, MobEffect> getMinecraftEffectWidthTexturedParticles() {
        HashMap<ParticleOptions, MobEffect> map = new HashMap<ParticleOptions, MobEffect>();
        map.put((ParticleOptions)ParticleTypes.ITEM_SLIME, (MobEffect)MobEffects.OOZING.value());
        map.put((ParticleOptions)ParticleTypes.ITEM_COBWEB, (MobEffect)MobEffects.WEAVING.value());
        map.put((ParticleOptions)ParticleTypes.INFESTED, (MobEffect)MobEffects.INFESTED.value());
        map.put((ParticleOptions)ParticleTypes.TRIAL_OMEN, (MobEffect)MobEffects.TRIAL_OMEN.value());
        map.put((ParticleOptions)ParticleTypes.RAID_OMEN, (MobEffect)MobEffects.RAID_OMEN.value());
        map.put((ParticleOptions)ParticleTypes.SMALL_GUST, (MobEffect)MobEffects.WIND_CHARGED.value());
        return map;
    }

    public static MobEffect getVanillaStatusEffectByStatusEffect(ParticleOptions parameters) {
        return MINECRAFT_EFFECTS_WITH_TEXTURED_PARTICLE.get(parameters);
    }

    public static void processSplashPotionStageOne(LocalRef<List<ParticleOptions>> localParticleEffects, int color) {
        localParticleEffects.set(null);
        if (!((Boolean)ParticleEffectsConfig.CLIENT.modEnabled.get()).booleanValue()) {
            return;
        }
        List<ParticleOptions> list = ParticleEffectsManager.getParticleEffects(ArgbUtils.getColorWithoutAlpha(color));
        if (list == null) {
            return;
        }
        localParticleEffects.set(list);
    }

    public static Particle processSplashPotionStageTwo(@Nullable Level world, LevelRenderer instance, ParticleOptions parameters, boolean alwaysSpawn, double x, double y, double z, double velocityX, double velocityY, double velocityZ, Operation<Particle> original, LocalRef<List<ParticleOptions>> localParticleEffects, int color) {
        if (!((Boolean)ParticleEffectsConfig.CLIENT.modEnabled.get()).booleanValue()) {
            return (Particle)original.call(new Object[]{instance, parameters, alwaysSpawn, x, y, z, velocityX, velocityY, velocityZ});
        }
        List list = (List)localParticleEffects.get();
        if (list == null || world == null) {
            return (Particle)original.call(new Object[]{instance, parameters, alwaysSpawn, x, y, z, velocityX, velocityY, velocityZ});
        }
        ParticleOptions particleEffect = (ParticleOptions)ListUtils.getRandomElement(list, world.getRandom());
        if (particleEffect == null) {
            return (Particle)original.call(new Object[]{instance, parameters, alwaysSpawn, x, y, z, velocityX, velocityY, velocityZ});
        }
        ((PEType)particleEffect).particleEffects$setColor(color);
        return (Particle)original.call(new Object[]{instance, particleEffect, alwaysSpawn, x, y, z, velocityX, velocityY, velocityZ});
    }
}

