/*
 * Decompiled with CFR 0.152.
 */
package xyz.trivaxy.tia;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.inventory.Slot;
import xyz.trivaxy.tia.Animated;
import xyz.trivaxy.tia.ModConfigs;

public class MixinInjects {
    private static Slot currentlyRenderingSlot = null;
    private static float carriedAnimationProgress = 0.0f;

    public static void preRenderFloatingItem(GuiGraphics gui, int leftPos, int topPos, int mouseX, int mouseY, float partialTicks) {
        PoseStack poseStack = gui.pose();
        if ((carriedAnimationProgress += partialTicks * ModConfigs.animationSpeed) > 1.0f) {
            carriedAnimationProgress = 1.0f;
        }
        poseStack.translate((float)(-(leftPos - mouseX)), (float)(-(topPos - mouseY - 4)), 0.0f);
        float scale = 1.0f + (ModConfigs.pickupScale - 1.0f) * (1.0f - (float)Math.pow(1.0f - carriedAnimationProgress, 5.0));
        poseStack.scale(scale, scale, scale);
        poseStack.translate((float)(leftPos - mouseX), (float)(topPos - mouseY - 4), 0.0f);
    }

    public static void postRenderSlot(Slot pSlot) {
        Animated slot = (Animated)pSlot;
        float progress = slot.getAnimationProgress();
        if ((progress -= Minecraft.getInstance().getTimer().getRealtimeDeltaTicks() * ModConfigs.animationSpeed) < 0.0f) {
            progress = 0.0f;
        }
        slot.setAnimationProgress(progress);
        currentlyRenderingSlot = null;
    }

    public static void preRenderSlotItem(Slot slot) {
        currentlyRenderingSlot = slot;
    }

    public static void onRenderSlot(PoseStack pose) {
        if (currentlyRenderingSlot == null) {
            return;
        }
        Animated slot = (Animated)currentlyRenderingSlot;
        float scale = 1.0f + (ModConfigs.pickupScale - 1.0f) * (1.0f - (float)Math.pow(1.0f - slot.getAnimationProgress(), 5.0));
        pose.scale(scale, scale, scale);
    }

    public static void onSlotStackedOn(Slot pSlot) {
        Animated slot = (Animated)pSlot;
        slot.setAnimationProgress(1.0f);
        carriedAnimationProgress = 0.0f;
    }
}

