/*
 * Decompiled with CFR 0.152.
 */
package io.github.avacadowizard120.cameraoverhaulneoforge.common.systems;

import io.github.avacadowizard120.cameraoverhaulneoforge.CameraOverhaulNeoForge;
import io.github.avacadowizard120.cameraoverhaulneoforge.common.configuration.ConfigData;
import io.github.avacadowizard120.cameraoverhaulneoforge.core.callbacks.CameraUpdateCallback;
import io.github.avacadowizard120.cameraoverhaulneoforge.core.callbacks.ModifyCameraTransformCallback;
import io.github.avacadowizard120.cameraoverhaulneoforge.core.structures.Transform;
import io.github.avacadowizard120.cameraoverhaulneoforge.core.utils.MathUtils;
import io.github.avacadowizard120.cameraoverhaulneoforge.core.utils.Vec2fUtils;
import net.minecraft.client.Camera;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class CameraSystem
implements CameraUpdateCallback,
ModifyCameraTransformCallback {
    private static double prevForwardVelocityPitchOffset;
    private static double prevVerticalVelocityPitchOffset;
    private static double prevStrafingRollOffset;
    private static double prevCameraYaw;
    private static double yawDeltaRollOffset;
    private static double yawDeltaRollTargetOffset;
    private static final Transform offsetTransform;

    public CameraSystem() {
        CameraUpdateCallback.EVENT.Register(this);
        ModifyCameraTransformCallback.EVENT.Register(this);
        CameraOverhaulNeoForge.LOGGER.info("CameraOverhaul - CameraSystem is ready.");
    }

    @Override
    public void OnCameraUpdate(Entity focusedEntity, Camera camera, Transform cameraTransform, float deltaTime) {
        boolean isFlying = false;
        boolean isSwimming = false;
        if (focusedEntity instanceof Player) {
            Player player = (Player)focusedEntity;
            isFlying = player.isFallFlying();
            isSwimming = player.isSwimming();
        }
        CameraSystem.offsetTransform.position = new Vec3(0.0, 0.0, 0.0);
        CameraSystem.offsetTransform.eulerRot = new Vec3(0.0, 0.0, 0.0);
        ConfigData config = CameraOverhaulNeoForge.instance.config;
        if (!config.enabled) {
            return;
        }
        float strafingRollFactorToUse = config.strafingRollFactor;
        if (isFlying) {
            strafingRollFactorToUse = config.getStrafingRollFactorWhenFlying;
        } else if (isSwimming) {
            strafingRollFactorToUse = config.getGetStrafingRollFactorWhenSwimming;
        }
        Vec3 velocity = camera.getEntity().getDeltaMovement();
        Vec2 relativeXZVelocity = Vec2fUtils.Rotate(new Vec2((float)velocity.x, (float)velocity.z), 360.0f - (float)cameraTransform.eulerRot.y);
        if (strafingRollFactorToUse == config.getStrafingRollFactorWhenFlying && !CameraOverhaulNeoForge.ClientModEvents.isBarrelLoaded) {
            this.VerticalVelocityPitchOffset(cameraTransform, velocity, relativeXZVelocity, deltaTime, config.verticalVelocityPitchFactor, config.verticalVelocitySmoothingFactor);
            this.ForwardVelocityPitchOffset(cameraTransform, velocity, relativeXZVelocity, deltaTime, config.forwardVelocityPitchFactor, config.horizontalVelocitySmoothingFactor);
            this.YawDeltaRollOffset(cameraTransform, velocity, relativeXZVelocity, deltaTime, config.yawDeltaRollFactor * 1.25f, config.yawDeltaSmoothingFactor, config.yawDeltaDecayFactor);
            this.StrafingRollOffset(cameraTransform, velocity, relativeXZVelocity, deltaTime, strafingRollFactorToUse, config.horizontalVelocitySmoothingFactor);
        } else if (strafingRollFactorToUse != config.getStrafingRollFactorWhenFlying) {
            this.VerticalVelocityPitchOffset(cameraTransform, velocity, relativeXZVelocity, deltaTime, config.verticalVelocityPitchFactor, config.verticalVelocitySmoothingFactor);
            this.ForwardVelocityPitchOffset(cameraTransform, velocity, relativeXZVelocity, deltaTime, config.forwardVelocityPitchFactor, config.horizontalVelocitySmoothingFactor);
            this.YawDeltaRollOffset(cameraTransform, velocity, relativeXZVelocity, deltaTime, config.yawDeltaRollFactor * 1.25f, config.yawDeltaSmoothingFactor, config.yawDeltaDecayFactor);
            this.StrafingRollOffset(cameraTransform, velocity, relativeXZVelocity, deltaTime, strafingRollFactorToUse, config.horizontalVelocitySmoothingFactor);
        }
        prevCameraYaw = cameraTransform.eulerRot.y;
    }

    @Override
    public Transform ModifyCameraTransform(Camera camera, Transform transform) {
        return new Transform(transform.position.add(CameraSystem.offsetTransform.position), transform.eulerRot.add(CameraSystem.offsetTransform.eulerRot));
    }

    private void VerticalVelocityPitchOffset(Transform inputTransform, Vec3 velocity, Vec2 relativeXZVelocity, double deltaTime, float intensity, float smoothing) {
        double verticalVelocityPitchOffset = velocity.y * 2.75;
        if (velocity.y < 0.0) {
            verticalVelocityPitchOffset *= 2.25;
        }
        prevVerticalVelocityPitchOffset = verticalVelocityPitchOffset = MathUtils.Damp(prevVerticalVelocityPitchOffset, verticalVelocityPitchOffset, (double)smoothing, deltaTime);
        CameraSystem.offsetTransform.eulerRot = CameraSystem.offsetTransform.eulerRot.add(verticalVelocityPitchOffset * (double)intensity, 0.0, 0.0);
    }

    private void ForwardVelocityPitchOffset(Transform inputTransform, Vec3 velocity, Vec2 relativeXZVelocity, double deltaTime, float intensity, float smoothing) {
        double forwardVelocityPitchOffset = (double)relativeXZVelocity.y * 5.0;
        prevForwardVelocityPitchOffset = forwardVelocityPitchOffset = MathUtils.Damp(prevForwardVelocityPitchOffset, forwardVelocityPitchOffset, (double)smoothing, deltaTime);
        CameraSystem.offsetTransform.eulerRot = CameraSystem.offsetTransform.eulerRot.add(forwardVelocityPitchOffset * (double)intensity, 0.0, 0.0);
    }

    private void YawDeltaRollOffset(Transform inputTransform, Vec3 velocity, Vec2 relativeXZVelocity, double deltaTime, float intensity, float offsetSmoothing, float decaySmoothing) {
        double yawDelta = prevCameraYaw - inputTransform.eulerRot.y;
        if (yawDelta > 180.0) {
            yawDelta = 360.0 - yawDelta;
        } else if (yawDelta < -180.0) {
            yawDelta = -360.0 - yawDelta;
        }
        yawDeltaRollOffset = MathUtils.Damp(yawDeltaRollOffset, yawDeltaRollTargetOffset += yawDelta * 0.07, (double)offsetSmoothing, deltaTime);
        CameraSystem.offsetTransform.eulerRot = CameraSystem.offsetTransform.eulerRot.add(0.0, 0.0, yawDeltaRollOffset * (double)intensity);
        yawDeltaRollTargetOffset = MathUtils.Damp(yawDeltaRollTargetOffset, 0.0, (double)decaySmoothing, deltaTime);
    }

    private void StrafingRollOffset(Transform inputTransform, Vec3 velocity, Vec2 relativeXZVelocity, double deltaTime, float intensity, float smoothing) {
        double strafingRollOffset = (double)(-relativeXZVelocity.x) * 15.0;
        prevStrafingRollOffset = strafingRollOffset = MathUtils.Damp(prevStrafingRollOffset, strafingRollOffset, (double)smoothing, deltaTime);
        CameraSystem.offsetTransform.eulerRot = CameraSystem.offsetTransform.eulerRot.add(0.0, 0.0, strafingRollOffset * (double)intensity);
    }

    static {
        offsetTransform = new Transform();
    }
}

