/*
 * Decompiled with CFR 0.152.
 */
package com.ntf;

import com.ntf.PlayerNoteStorage;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class NotesHistoryScreen
extends Screen {
    private final Screen parent;
    private final String player;
    private final List<PlayerNoteStorage.TimestampedNote> history;
    private int scrollOffset = 0;
    private final int maxVisible = 6;

    public NotesHistoryScreen(Screen parent, String player, List<PlayerNoteStorage.TimestampedNote> history) {
        super((Component)Component.literal((String)("History: " + player)));
        this.parent = parent;
        this.player = player;
        this.history = history;
    }

    public static NotesHistoryScreen buildHistoryScreen(Screen parent, String player) {
        List<PlayerNoteStorage.TimestampedNote> playerHistory = PlayerNoteStorage.getNoteHistory(player);
        return new NotesHistoryScreen(parent, player, playerHistory);
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), button -> {
            assert (this.minecraft != null);
            this.minecraft.setScreen(this.parent);
        }).bounds(centerX - 180, this.height - 30, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Clear History"), button -> {
            PlayerNoteStorage.clearNoteHistory(this.player);
            assert (this.minecraft != null);
            this.minecraft.setScreen(this.parent);
        }).bounds(centerX - 60, this.height - 30, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Clear All Histories"), button -> {
            PlayerNoteStorage.clearAllNoteHistories();
            assert (this.minecraft != null);
            this.minecraft.setScreen(this.parent);
        }).bounds(centerX + 60, this.height - 30, 150, 20).build());
        int yStart = 40;
        int spacing = 30;
        int endIndex = Math.min(this.scrollOffset + 6, this.history.size());
        for (int i = this.scrollOffset; i < endIndex; ++i) {
            PlayerNoteStorage.TimestampedNote tsNote = this.history.get(i);
            int displayIndex = i + 1;
            String displayText = displayIndex + ". [" + tsNote.timestamp + "] " + (String)(tsNote.note.length() > 25 ? tsNote.note.substring(0, 25) + "..." : tsNote.note);
            int y = yStart + (i - this.scrollOffset) * spacing;
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)displayText), button -> {
                PlayerNoteStorage.saveNote(this.player, tsNote.note);
                assert (this.minecraft != null);
                this.minecraft.setScreen(this.parent);
            }).bounds(centerX - 100, y, 200, 20).build());
        }
        if (this.history.size() > 6) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2191"), button -> {
                this.scrollOffset = Math.max(this.scrollOffset - 1, 0);
                this.init();
            }).bounds(centerX + 110, yStart, 20, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2193"), button -> {
                this.scrollOffset = Math.min(this.scrollOffset + 1, this.history.size() - 6);
                this.init();
            }).bounds(centerX + 110, yStart + 5 * spacing, 20, 20).build());
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.font, (Component)Component.literal((String)("History of " + this.player)).withStyle(ChatFormatting.YELLOW), this.width / 2, 10, 0xFFFFFF);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

