/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.gui;

import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.gui.util.TextWidget;
import fudge.notenoughcrashes.gui.util.Widget;
import fudge.notenoughcrashes.platform.CommonModMetadata;
import fudge.notenoughcrashes.stacktrace.ModIdentifier;
import fudge.notenoughcrashes.upload.CrashyUpload;
import fudge.notenoughcrashes.upload.LegacyCrashLogUpload;
import fudge.notenoughcrashes.utils.NecLocalization;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.ReportType;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ProblemScreen
extends Screen {
    private static final Set<String> IGNORED_MODS = new HashSet<String>(Arrays.asList("minecraft", "fabricloader", "loadcatcher", "jumploader", "quilt_loader", "forge", "notenoughcrashes"));
    private static final int GREEN = 65280;
    private static final int GRAY = 0x9A9A9A;
    private static final Component uploadToCrashyText = NecLocalization.translatedText("notenoughcrashes.gui.uploadToCrashy").copy();
    private static final Component uploadToCrashyLoadingText = NecLocalization.translatedText("notenoughcrashes.gui.loadingCrashyUpload");
    private List<Widget> widgets = new ArrayList<Widget>();
    protected CrashReport report;
    private String uploadedCrashLink = null;
    protected int xLeft = Integer.MAX_VALUE;
    protected int xRight = Integer.MIN_VALUE;
    protected int yTop = Integer.MAX_VALUE;
    protected int yBottom = Integer.MIN_VALUE;
    protected int x;
    protected int y;
    private String crashyLink = null;

    protected void addWidget(Widget widget) {
        this.widgets.add(widget);
    }

    public abstract ProblemScreen construct(CrashReport var1);

    protected ProblemScreen(CrashReport report) {
        super(Component.nullToEmpty((String)""));
        this.report = report;
    }

    private Component getSuspectedModsText() {
        Set<CommonModMetadata> suspectedMods = ModIdentifier.getSuspectedModsOf(this.report);
        suspectedMods.removeIf(mod -> IGNORED_MODS.contains(mod.id()));
        if (suspectedMods.isEmpty()) {
            return NecLocalization.translatedText("notenoughcrashes.crashscreen.noModsErrored");
        }
        return (Component)suspectedMods.stream().sorted(Comparator.comparing(CommonModMetadata::name)).map(mod -> {
            String issuesPage = mod.issuesPage();
            MutableComponent modText = Component.literal((String)mod.name());
            if (issuesPage != null) {
                modText.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, issuesPage)));
            }
            return modText;
        }).reduce((existing, next) -> existing.append(Component.nullToEmpty((String)", ")).append((Component)next)).get();
    }

    private void addSuspectedModsWidget() {
        this.addWidget(new TextWidget(this.getSuspectedModsText(), 0xE0E000, this.font, this.width / 2, this.y + 29));
    }

    private void handleLegacyLinkClick(Button buttonWidget) {
        try {
            if (this.uploadedCrashLink == null) {
                this.uploadedCrashLink = LegacyCrashLogUpload.upload(this.report.getFriendlyReport(ReportType.CRASH));
            }
            Util.getPlatform().openUri(this.uploadedCrashLink);
        }
        catch (Throwable e) {
            NotEnoughCrashes.getLogger().error("Exception when crash menu button clicked:", e);
            buttonWidget.setMessage(NecLocalization.translatedText("notenoughcrashes.gui.failed"));
            buttonWidget.active = false;
        }
    }

    private void handleCrashyUploadClick(Button buttonWidget) {
        try {
            if (this.crashyLink == null) {
                buttonWidget.active = false;
                buttonWidget.setMessage(uploadToCrashyLoadingText);
                CrashyUpload.uploadToCrashy(this.report.getFriendlyReport(ReportType.CRASH)).thenAccept(link -> {
                    this.crashyLink = link;
                    buttonWidget.active = true;
                    buttonWidget.setMessage(uploadToCrashyText);
                    Util.getPlatform().openUri(this.crashyLink);
                });
            } else {
                Util.getPlatform().openUri(this.crashyLink);
            }
        }
        catch (Throwable e) {
            NotEnoughCrashes.getLogger().error("Exception uploading to crashy", e);
            buttonWidget.setMessage(NecLocalization.translatedText("notenoughcrashes.gui.failed"));
            buttonWidget.active = false;
        }
    }

    public void init() {
        this.widgets = new ArrayList<Widget>();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)NecLocalization.translatedText("notenoughcrashes.gui.getLink"), this::handleLegacyLinkClick).bounds(this.width / 2 - 155 + 160, this.height / 4 + 144 + 12, 150, 20).build());
        this.x = this.width / 2 - 155;
        this.y = this.height / 4;
        this.addSuspectedModsWidget();
    }

    public boolean mouseClicked(double x, double y, int int_1) {
        Path file;
        for (Widget widget : this.widgets) {
            widget.onClick(x, y);
        }
        if (x >= (double)this.xLeft && x <= (double)this.xRight && y >= (double)this.yTop && y <= (double)this.yBottom && (file = this.report.getSaveFile()) != null) {
            Util.getPlatform().openPath(file);
        }
        return super.mouseClicked(x, y, int_1);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    protected void drawFileNameString(GuiGraphics context, int y) {
        String fileNameString = this.report.getSaveFile() != null ? "\u00a7n" + String.valueOf(this.report.getSaveFile().getFileName()) : NecLocalization.localize("notenoughcrashes.crashscreen.reportSaveFailed");
        int stLen = this.font.width(fileNameString);
        this.xLeft = this.width / 2 - stLen / 2;
        this.xRight = this.width / 2 + stLen / 2;
        context.drawString(this.font, fileNameString, this.xLeft, y += 11, 65280);
        this.yTop = y;
        this.yBottom = y + 10;
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        for (Widget widget : this.widgets) {
            widget.draw(context);
        }
    }
}

