/*
 * Decompiled with CFR 0.152.
 */
package com.ilexiconn.llibrary.server.network;

import com.bobmowzie.mowziesmobs.MMCommon;
import com.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record AnimationMessage(int entityId, int index) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AnimationMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"animation_message"));
    public static final StreamCodec<ByteBuf, AnimationMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, AnimationMessage::entityId, (StreamCodec)ByteBufCodecs.INT, AnimationMessage::index, AnimationMessage::new);

    public static void handleClient(AnimationMessage packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp;
            Level level = MMCommon.PROXY.getClientLevel();
            if (level != null && (patt0$temp = level.getEntity(packet.entityId())) instanceof IAnimatedEntity) {
                IAnimatedEntity entity = (IAnimatedEntity)patt0$temp;
                if (packet.index() == -1) {
                    entity.setAnimation(IAnimatedEntity.NO_ANIMATION);
                } else {
                    entity.setAnimation(entity.getAnimations()[packet.index()]);
                }
                entity.setAnimationTick(0);
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

