/*
 * Decompiled with CFR 0.152.
 */
package com.ilexiconn.llibrary.server.animation;

import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import com.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class AnimationAI<T extends Entity>
extends Goal {
    protected T entity;

    public AnimationAI(T entity) {
        this.entity = entity;
    }

    public abstract Animation getAnimation();

    public boolean isAutomatic() {
        return false;
    }

    public boolean shouldAnimate() {
        return false;
    }

    public boolean canUse() {
        if (this.isAutomatic()) {
            return ((IAnimatedEntity)this.entity).getAnimation() == this.getAnimation();
        }
        return this.shouldAnimate();
    }

    public void start() {
        if (!this.isAutomatic()) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this.entity, this.getAnimation());
        }
        ((IAnimatedEntity)this.entity).setAnimationTick(0);
    }

    public boolean canContinueToUse() {
        return ((IAnimatedEntity)this.entity).getAnimationTick() < this.getAnimation().getDuration();
    }

    public void stop() {
        AnimationHandler.INSTANCE.sendAnimationMessage(this.entity, IAnimatedEntity.NO_ANIMATION);
    }
}

