/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.umvuthana;

import com.bobmowzie.mowziesmobs.MMCommon;
import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimationController;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleOrb;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.sound.BossMusic;
import com.bobmowzie.mowziesmobs.client.sound.BossMusicPlayer;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.abilities.mob.DieAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.mob.HurtAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.SimpleAnimationAbility;
import com.bobmowzie.mowziesmobs.server.advancement.AdvancementHandler;
import com.bobmowzie.mowziesmobs.server.advancement.SneakGroveTrigger;
import com.bobmowzie.mowziesmobs.server.ai.LookAtTargetGoal;
import com.bobmowzie.mowziesmobs.server.ai.NearestAttackableTargetPredicateGoal;
import com.bobmowzie.mowziesmobs.server.ai.UmvuthanaHurtByTargetAI;
import com.bobmowzie.mowziesmobs.server.ai.UseAbilityAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.MowzieGeckoEntity;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySolarBeam;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySunstrike;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySuperNova;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthana;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaCrane;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaMinion;
import com.bobmowzie.mowziesmobs.server.inventory.ContainerUmvuthiTrade;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.UmvuthanaMask;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class EntityUmvuthi
extends MowzieGeckoEntity
implements LeaderSunstrikeImmune,
Enemy {
    public static final AbilityType<EntityUmvuthi, DieAbility<EntityUmvuthi>> DIE_ABILITY = new AbilityType<EntityUmvuthi, DieAbility>("umvuthi_die", (type, entity) -> new DieAbility<EntityUmvuthi>(type, entity, RawAnimation.begin().thenPlay("death"), 115){

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getTicksInUse() == 1) {
                ((EntityUmvuthi)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_UMVUTHI_HURT.get(), ((EntityUmvuthi)this.getUser()).getSoundVolume(), ((EntityUmvuthi)this.getUser()).getVoicePitch());
            }
            if (this.getTicksInUse() == 14) {
                ((EntityUmvuthi)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_UMVUTHI_DIE.get(), ((EntityUmvuthi)this.getUser()).getSoundVolume(), 1.0f);
            }
            if (this.getTicksInUse() == 80) {
                ((EntityUmvuthi)this.getUser()).playSound((SoundEvent)MMSounds.MISC_METAL_IMPACT.get(), ((EntityUmvuthi)this.getUser()).getSoundVolume(), 1.0f);
            }
        }
    });
    public static final AbilityType<EntityUmvuthi, HurtAbility<EntityUmvuthi>> HURT_ABILITY = new AbilityType<EntityUmvuthi, HurtAbility>("umvuthi_hurt", (type, entity) -> new HurtAbility<EntityUmvuthi>(type, (EntityUmvuthi)entity, RawAnimation.begin().thenPlay("hurt"), 13, 10));
    public static final AbilityType<EntityUmvuthi, SimpleAnimationAbility<EntityUmvuthi>> BELLY_ABILITY = new AbilityType<EntityUmvuthi, SimpleAnimationAbility>("umvuthi_belly", (type, entity) -> new SimpleAnimationAbility<EntityUmvuthi>(type, entity, RawAnimation.begin().thenPlay("belly_drum"), 40, true){

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getTicksInUse() == 9 || this.getTicksInUse() == 29) {
                ((EntityUmvuthi)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_UMVUTHI_BELLY.get(), 3.0f, 1.0f);
            }
        }
    });
    public static final AbilityType<EntityUmvuthi, SimpleAnimationAbility<EntityUmvuthi>> TALK_ABILITY = new AbilityType<EntityUmvuthi, SimpleAnimationAbility>("umvuthi_talk", (type, entity) -> new SimpleAnimationAbility<EntityUmvuthi>(type, (EntityUmvuthi)entity, RawAnimation.begin().thenPlay("talk"), 23, true));
    public static final AbilityType<EntityUmvuthi, SimpleAnimationAbility<EntityUmvuthi>> ROAR_ABILITY = new AbilityType<EntityUmvuthi, SimpleAnimationAbility>("umvuthi_roar", (type, entity) -> new SimpleAnimationAbility<EntityUmvuthi>(type, entity, RawAnimation.begin().thenPlay("roar"), 70, false){

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getTicksInUse() == 2) {
                ((EntityUmvuthi)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_UMVUTHI_ROAR.get(), 3.0f, 1.0f);
            }
        }
    });
    public static final AbilityType<EntityUmvuthi, SunstrikeAbility> SUNSTRIKE_ABILITY = new AbilityType<EntityUmvuthi, SunstrikeAbility>("umvuthi_sunstrike", SunstrikeAbility::new);
    public static final AbilityType<EntityUmvuthi, SolarFlareAbility> SOLAR_FLARE_ABILITY = new AbilityType<EntityUmvuthi, SolarFlareAbility>("umvuthi_flare", SolarFlareAbility::new);
    public static final AbilityType<EntityUmvuthi, SpawnFollowersAbility> SPAWN_ABILITY = new AbilityType<EntityUmvuthi, SpawnFollowersAbility>("umvuthi_spawn", (type, entity) -> new SpawnFollowersAbility(type, (EntityUmvuthi)entity, false));
    public static final AbilityType<EntityUmvuthi, SpawnFollowersAbility> SPAWN_SUNBLOCKERS_ABILITY = new AbilityType<EntityUmvuthi, SpawnFollowersAbility>("umvuthi_spawn_healers", (type, entity) -> new SpawnFollowersAbility(type, (EntityUmvuthi)entity, true));
    public static final AbilityType<EntityUmvuthi, SolarBeamAbility> SOLAR_BEAM_ABILITY = new AbilityType<EntityUmvuthi, SolarBeamAbility>("umvuthi_solar_beam", SolarBeamAbility::new);
    public static final AbilityType<EntityUmvuthi, SimpleAnimationAbility<EntityUmvuthi>> BLESS_ABILITY = new AbilityType<EntityUmvuthi, SimpleAnimationAbility>("umvuthi_bless", (type, entity) -> new SimpleAnimationAbility<EntityUmvuthi>(type, entity, RawAnimation.begin().thenPlay("bless"), 84){

        @Override
        public boolean canCancelActiveAbility() {
            return ((EntityUmvuthi)this.getUser()).getActiveAbilityType() == ROAR_ABILITY || ((EntityUmvuthi)this.getUser()).getActiveAbilityType() == TALK_ABILITY || ((EntityUmvuthi)this.getUser()).getActiveAbilityType() == BELLY_ABILITY;
        }
    });
    public static final AbilityType<EntityUmvuthi, SupernovaAbility> SUPERNOVA_ABILITY = new AbilityType<EntityUmvuthi, SupernovaAbility>("umvuthi_supernova", SupernovaAbility::new);
    protected AnimationController<MowzieGeckoEntity> maskController = new MowzieAnimationController<EntityUmvuthi>(this, "mask_controller", 1, this::predicateMask, 0.0);
    protected AnimationController<MowzieGeckoEntity> blinkController = new MowzieAnimationController<EntityUmvuthi>(this, "blink_controller", 1, this::predicateBlink, 0.0);
    private static final int MAX_HEALTH = 150;
    private static final int SUNSTRIKE_PAUSE_MAX = 50;
    private static final int SUNSTRIKE_PAUSE_MIN = 30;
    private static final int LASER_PAUSE = 230;
    private static final int SUPERNOVA_PAUSE = 230;
    private static final int UMVUTHANA_PAUSE = 200;
    private static final int ROAR_PAUSE = 300;
    private static final int HEAL_PAUSE = 75;
    private static int HEALTH_LOST_BETWEEN_SUNBLOCKERS = 45;
    private static final EntityDataAccessor<Integer> DIRECTION = SynchedEntityData.defineId(EntityUmvuthi.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DIALOGUE = SynchedEntityData.defineId(EntityUmvuthi.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.defineId(EntityUmvuthi.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<ItemStack> DESIRES = SynchedEntityData.defineId(EntityUmvuthi.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<CompoundTag> TRADED_PLAYERS = SynchedEntityData.defineId(EntityUmvuthi.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final EntityDataAccessor<Float> HEALTH_LOST = SynchedEntityData.defineId(EntityUmvuthi.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Optional<UUID>> MISBEHAVED_PLAYER = SynchedEntityData.defineId(EntityUmvuthi.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> IS_TRADING = SynchedEntityData.defineId(EntityUmvuthi.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public ControlledAnimation legsUp = new ControlledAnimation(15);
    public ControlledAnimation angryEyebrow = new ControlledAnimation(5);
    private Player customer;
    public int umvuthanaSpawnCount = 0;
    private int direction = 0;
    private boolean blocksByFeet = true;
    private int timeUntilSunstrike = 0;
    private int timeUntilLaser = 0;
    private int timeUntilUmvuthana = 0;
    private int timeUntilRoar = 0;
    private int timeUntilSupernova = 0;
    private int timeUntilHeal = 0;
    public Player blessingPlayer;
    private UmvuthanaHurtByTargetAI hurtByTargetAI;
    public Vec3[] betweenHandPos;
    public Vec3[] headPos;
    public Vec3[] blessingPlayerPos;
    private static final TargetingConditions GIVE_ACHIEVEMENT_PRED = TargetingConditions.forCombat().ignoreInvisibilityTesting();
    private float prevMaskRot = 0.0f;
    private boolean rattling = false;
    private static RawAnimation MASK_TWITCH_ANIM = RawAnimation.begin().thenLoop("mask_twitch");
    private static RawAnimation BLINK_ANIM = RawAnimation.begin().thenLoop("blink");

    public EntityUmvuthi(EntityType<? extends EntityUmvuthi> type, Level world) {
        super(type, world);
        if (this.getDirectionData() == 0) {
            this.setDirection(this.random.nextInt(4) + 1);
        }
        this.xpReward = 45;
        if (world.isClientSide) {
            this.headPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
            this.betweenHandPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
            this.blessingPlayerPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
        }
        this.active = true;
        HEALTH_LOST_BETWEEN_SUNBLOCKERS = (Integer)ConfigHandler.COMMON.MOBS.UMVUTHI.spawnHealersThreshold.get();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.hurtByTargetAI = new UmvuthanaHurtByTargetAI(this, false, new Class[0]);
        this.targetSelector.addGoal(3, (Goal)this.hurtByTargetAI);
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetPredicateGoal<Player>((Mob)this, Player.class, 0, false, true, TargetingConditions.forCombat().range(this.getAttributeValue(Attributes.FOLLOW_RANGE)).selector(target -> {
            if (target instanceof Player) {
                if (this.level().getDifficulty() == Difficulty.PEACEFUL) {
                    return false;
                }
                ItemStack headArmorStack = (ItemStack)((Player)target).getInventory().armor.get(3);
                return !(headArmorStack.getItem() instanceof UmvuthanaMask) || target == this.getMisbehavedPlayer();
            }
            return true;
        }).ignoreLineOfSight()){

            public void stop() {
                super.stop();
                EntityUmvuthi.this.setMisbehavedPlayerId(null);
            }
        });
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, 0, false, false, null));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, 0, false, false, e -> !(e instanceof ZombifiedPiglin)));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, 0, false, false, null));
        this.goalSelector.addGoal(1, new UseAbilityAI<EntityUmvuthi>(this, DIE_ABILITY));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthi>(this, HURT_ABILITY, false));
        this.goalSelector.addGoal(6, new UseAbilityAI<EntityUmvuthi>(this, BELLY_ABILITY, false));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthi>(this, SUNSTRIKE_ABILITY));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthi>(this, SOLAR_FLARE_ABILITY));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthi>(this, SOLAR_BEAM_ABILITY));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthi>(this, SUPERNOVA_ABILITY));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthi>(this, SPAWN_ABILITY));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthi>(this, SPAWN_SUNBLOCKERS_ABILITY));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthi>(this, BLESS_ABILITY));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthi>(this, TALK_ABILITY, false));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthi>(this, ROAR_ABILITY, true));
        this.goalSelector.addGoal(5, (Goal)new LookAtTargetGoal((Mob)this, 24.0f));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, EntityUmvuthana.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MowzieEntity.createAttributes().add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MAX_HEALTH, 150.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 40.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        super.registerControllers(controllers);
        controllers.add(this.maskController);
        controllers.add(this.blinkController);
    }

    protected <E extends GeoEntity> PlayState predicateMask(AnimationState<E> state) {
        if (this.isAlive() && this.getActiveAbilityType() != SOLAR_BEAM_ABILITY && this.getActiveAbilityType() != SUPERNOVA_ABILITY && this.getActiveAbilityType() != SPAWN_ABILITY && this.getActiveAbilityType() != SPAWN_SUNBLOCKERS_ABILITY) {
            state.getController().setAnimation(MASK_TWITCH_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    protected <E extends GeoEntity> PlayState predicateBlink(AnimationState<E> event) {
        if (this.isAlive() && this.getActiveAbilityType() != SOLAR_BEAM_ABILITY) {
            event.getController().setAnimation(BLINK_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    @Override
    protected <E extends GeoEntity> void loopingAnimations(AnimationState<E> event) {
        event.getController().transitionLength(4);
        super.loopingAnimations(event);
    }

    public boolean requiresCustomPersistence() {
        return true;
    }

    protected SoundEvent getAmbientSound() {
        if (this.getActiveAbility() == null) {
            this.sendAbilityMessage(TALK_ABILITY);
            return (SoundEvent)MMSounds.ENTITY_UMVUTHI_IDLE.get();
        }
        return null;
    }

    public void updateRattleSound(float maskRot) {
        if (!this.rattling) {
            if ((double)Math.abs(maskRot - this.prevMaskRot) > 0.05) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)MMSounds.ENTITY_UMVUTHANA_RATTLE.get(), SoundSource.HOSTILE, 0.04f, this.getVoicePitch() * 0.75f, false);
            }
        } else if ((double)Math.abs(maskRot - this.prevMaskRot) < 1.0E-8) {
            this.rattling = false;
        }
        this.prevMaskRot = maskRot;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)MMSounds.ENTITY_UMVUTHI_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return null;
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public boolean shouldRenderSun() {
        return this.deathTime < 85 && (this.getActiveAbilityType() != SUPERNOVA_ABILITY || this.getActiveAbility().getTicksInUse() <= 5 || this.getActiveAbility().getTicksInUse() > 90);
    }

    @Override
    public void tick() {
        double oz;
        double oy;
        double ox;
        this.legsUp.updatePrevTimer();
        this.angryEyebrow.updatePrevTimer();
        this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
        super.tick();
        if (this.tickCount == 1) {
            this.direction = this.getDirectionData();
        }
        if (this.getActiveAbilityType() != SOLAR_FLARE_ABILITY || this.getActiveAbility().getTicksInUse() < 12 || this.getActiveAbility().getTicksInUse() > 14) {
            this.repelEntities(1.2f, 1.2f, 1.2f, 1.2f);
        }
        this.setYRot((this.direction - 1) * 90);
        this.yBodyRot = this.getYRot();
        if (this.level().isClientSide() && this.shouldRenderSun() && this.headPos != null && this.headPos.length > 0 && this.headPos[0] != null) {
            if (this.tickCount % 10 == 1) {
                AdvancedParticleBase.spawnParticle(this.level(), ParticleHandler.GLOW, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.3, 0.4, 1.0, 9.0, true, false, new ParticleComponent[]{new ParticleComponent.PinLocation(this.headPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.oscillate(12.5f, 13.5f, 12), false)});
            }
            if (this.random.nextFloat() < 0.3f) {
                int amount = this.random.nextInt(2) + 1;
                while (amount-- > 0) {
                    float theta = this.random.nextFloat() * ((float)Math.PI * 2);
                    float r = this.random.nextFloat() * 0.4f;
                    float x = r * Mth.cos((float)theta);
                    float z = r * Mth.sin((float)theta);
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.headPos[0].x() + (double)x, this.headPos[0].y() + 0.1, this.headPos[0].z() + (double)z, 0.0, 0.0, 0.0);
                }
            }
        }
        if (!this.level().isClientSide && this.getHealthLost() >= (float)HEALTH_LOST_BETWEEN_SUNBLOCKERS && this.getActiveAbility() == null && !this.isNoAi() && this.getEntitiesNearby(EntityUmvuthanaCrane.class, 40.0).size() < 3) {
            this.sendAbilityMessage(SPAWN_SUNBLOCKERS_ABILITY);
            this.setHealthLost(0.0f);
        }
        if (this.getTarget() != null) {
            boolean targetComingCloser;
            LivingEntity target = this.getTarget();
            this.setAngry(true);
            float entityHitAngle = (float)((Math.atan2(target.getZ() - this.getZ(), target.getX() - this.getX()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.getYRot() % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = Math.abs(entityHitAngle - entityAttackingAngle);
            Vec3 betweenEntitiesVec = this.position().subtract(target.position());
            boolean bl = targetComingCloser = target.getDeltaMovement().dot(betweenEntitiesVec) > 0.0 && target.getDeltaMovement().lengthSqr() > 0.015;
            if (this.getActiveAbility() == null && !this.isNoAi() && this.random.nextInt(80) == 0 && ((double)this.targetDistance > 5.5 || this.hasEffect((Holder)EffectHandler.SUNBLOCK)) && this.timeUntilUmvuthana <= 0 && this.getEntitiesNearby(EntityUmvuthana.class, 50.0).size() < 4) {
                this.sendAbilityMessage(SPAWN_ABILITY);
                this.timeUntilUmvuthana = 200;
            } else if (this.getActiveAbility() == null && !this.isNoAi() && (double)this.getHealthRatio() <= 0.6 && this.timeUntilLaser <= 0 && (entityRelativeAngle < 60.0f || entityRelativeAngle > 300.0f) && this.getSensing().hasLineOfSight((Entity)target) && (double)this.targetDistance < 30.0) {
                this.sendAbilityMessage(SOLAR_BEAM_ABILITY);
                this.timeUntilLaser = 230;
            } else if (this.getActiveAbility() == null && !this.isNoAi() && (double)this.getHealthRatio() <= 0.6 && !this.hasEffect((Holder)EffectHandler.SUNBLOCK) && this.timeUntilSupernova <= 0 && (double)this.targetDistance <= 10.5) {
                this.sendAbilityMessage(SUPERNOVA_ABILITY);
                this.timeUntilSupernova = 230;
            } else if (this.getActiveAbility() == null && !this.isNoAi() && (this.targetDistance <= 6.0f && targetComingCloser || this.targetDistance < 4.0f)) {
                this.sendAbilityMessage(SOLAR_FLARE_ABILITY);
            } else if (this.getActiveAbility() == null && !this.isNoAi() && this.timeUntilSunstrike <= 0) {
                this.sendAbilityMessage(SUNSTRIKE_ABILITY);
                this.timeUntilSunstrike = this.getTimeUntilSunstrike();
            }
            if (this.hurtByTargetAI != null && !this.hurtByTargetAI.canContinueToUse()) {
                this.hurtByTargetAI.stop();
            }
        } else if (!this.level().isClientSide) {
            this.setAngry(false);
        }
        if (this.tickCount % 20 == 0) {
            this.blocksByFeet = this.checkBlocksByFeet();
        }
        if (this.blocksByFeet) {
            this.legsUp.increaseTimer();
        } else {
            this.legsUp.decreaseTimer();
        }
        if (this.getAngry()) {
            this.angryEyebrow.increaseTimer();
        } else {
            this.angryEyebrow.decreaseTimer();
        }
        if (this.getActiveAbility() == null && !this.isNoAi() && this.getTarget() == null && this.random.nextInt(200) == 0) {
            this.sendAbilityMessage(BELLY_ABILITY);
        }
        if (this.getActiveAbility() == null && !this.isNoAi() && this.getTarget() == null && this.timeUntilRoar <= 0 && this.random.nextInt(300) == 0) {
            this.sendAbilityMessage(ROAR_ABILITY);
            this.timeUntilRoar = 300;
        }
        if (this.getActiveAbilityType() == SOLAR_FLARE_ABILITY) {
            this.yHeadRot = this.getYRot();
            if (this.getActiveAbility().getTicksInUse() == 10) {
                if (this.level().isClientSide) {
                    this.spawnExplosionParticles(30);
                }
                this.playSound((SoundEvent)MMSounds.ENTITY_UMVUTHI_ATTACK.get(), 1.7f, 0.9f);
            }
            if (this.getActiveAbility().getTicksInUse() <= 6 && this.level().isClientSide) {
                int particleCount = 8;
                while (--particleCount != 0) {
                    double radius = 2.0;
                    double yaw = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
                    double pitch = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
                    ox = radius * Math.sin(yaw) * Math.sin(pitch);
                    oy = radius * Math.cos(pitch);
                    oz = radius * Math.cos(yaw) * Math.sin(pitch);
                    float offsetX = (float)(-0.3 * Math.sin((double)this.getYRot() * Math.PI / 180.0));
                    float offsetZ = (float)(-0.3 * Math.cos((double)this.getYRot() * Math.PI / 180.0));
                    float offsetY = 1.0f;
                    this.level().addParticle((ParticleOptions)ParticleOrb.Data.create((float)this.getX() + offsetX, (float)this.getY() + offsetY, (float)this.getZ() + offsetZ, 6.0f), this.getX() + ox + (double)offsetX, this.getY() + (double)offsetY + oy, this.getZ() + oz + (double)offsetZ, 0.0, 0.0, 0.0);
                }
            }
        }
        if (this.getActiveAbilityType() == BLESS_ABILITY) {
            this.yHeadRot = this.getYRot();
            if (this.getActiveAbility().getTicksInUse() == 1) {
                this.blessingPlayer = this.getCustomer();
            }
            if (this.level().isClientSide && this.blessingPlayer != null) {
                this.blessingPlayerPos[0] = this.blessingPlayer.position().add(new Vec3(0.0, (double)(this.blessingPlayer.getBbHeight() / 2.0f), 0.0));
                if (this.getActiveAbility().getTicksInUse() > 5 && this.getActiveAbility().getTicksInUse() < 40) {
                    int particleCount = 2;
                    while (--particleCount != 0) {
                        double radius = 0.7f;
                        double yaw = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
                        double pitch = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
                        ox = radius * Math.sin(yaw) * Math.sin(pitch);
                        oy = radius * Math.cos(pitch);
                        oz = radius * Math.cos(yaw) * Math.sin(pitch);
                        AdvancedParticleBase.spawnParticle(this.level(), ParticleHandler.ORB2, this.getX() + ox, this.getY() + (double)0.8f + oy, this.getZ() + oz, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 20.0, true, true, new ParticleComponent[]{new ParticleComponent.Attractor(this.blessingPlayerPos, 0.5f, 0.2f, ParticleComponent.Attractor.EnumAttractorBehavior.LINEAR), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_X, new ParticleComponent.Oscillator(0.0f, (float)ox, 6.0f, 2.5f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, new ParticleComponent.Oscillator(0.0f, (float)oy, 6.0f, 2.5f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Z, new ParticleComponent.Oscillator(0.0f, (float)oz, 6.0f, 2.5f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new ParticleComponent.KeyTrack(new float[]{0.0f, 1.0f}, new float[]{0.0f, 0.8f}), false)});
                    }
                }
                if (this.getActiveAbility().getTicksInUse() % 15 == 0) {
                    AdvancedParticleBase.spawnParticle(this.level(), ParticleHandler.RING2, this.getX(), this.getY() + (double)0.8f, this.getZ(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 3.5, 1.0, 0.8745098114013672, 0.25882354378700256, 1.0, 1.0, 15.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(5.0f, 35.0f), false)});
                }
            }
        }
        if (this.tickCount % 40 == 0) {
            for (Player player : this.getPlayersNearby(15.0, 15.0, 15.0, 15.0)) {
                ItemStack headArmorStack = (ItemStack)player.getInventory().armor.get(3);
                if (this.getTarget() == player || !this.canAttack((LivingEntity)player, GIVE_ACHIEVEMENT_PRED) || !(headArmorStack.getItem() instanceof UmvuthanaMask) || !(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((SneakGroveTrigger)((Object)AdvancementHandler.SNEAK_VILLAGE_TRIGGER.value())).trigger(serverPlayer);
            }
        }
        if (!this.level().isClientSide && this.getTarget() == null && this.getActiveAbilityType() != SOLAR_BEAM_ABILITY && this.getActiveAbilityType() != SUPERNOVA_ABILITY) {
            --this.timeUntilHeal;
            if (((Boolean)ConfigHandler.COMMON.MOBS.UMVUTHI.healsOutOfBattle.get()).booleanValue() && this.timeUntilHeal <= 0) {
                this.heal(0.3f);
            }
            if (this.getHealth() == this.getMaxHealth()) {
                this.setHealthLost(0.0f);
            }
        } else {
            this.timeUntilHeal = 75;
        }
        if (this.timeUntilSunstrike > 0) {
            --this.timeUntilSunstrike;
        }
        if (this.timeUntilLaser > 0 && this.getActiveAbilityType() != SUPERNOVA_ABILITY) {
            --this.timeUntilLaser;
        }
        if (this.timeUntilUmvuthana > 0) {
            --this.timeUntilUmvuthana;
        }
        if (this.timeUntilSupernova > 0 && this.getActiveAbilityType() != SOLAR_BEAM_ABILITY) {
            --this.timeUntilSupernova;
        }
        if (this.timeUntilRoar > 0) {
            --this.timeUntilRoar;
        }
    }

    @Override
    public AbilityType getHurtAbility() {
        return HURT_ABILITY;
    }

    @Override
    public AbilityType getDeathAbility() {
        return DIE_ABILITY;
    }

    @Override
    public boolean hurt(DamageSource source, float damage) {
        if (source == this.level().damageSources().hotFloor()) {
            return false;
        }
        if (this.hasEffect((Holder)EffectHandler.SUNBLOCK) && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            if (source.getDirectEntity() != null) {
                this.playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_UNDAMAGED.get(), 0.4f, 2.0f);
            }
            return false;
        }
        this.timeUntilHeal = 75;
        float prevHealth = this.getHealth();
        boolean superResult = super.hurt(source, damage);
        if (superResult) {
            float diffHealth = prevHealth - this.getHealth();
            this.setHealthLost(this.getHealthLost() + diffHealth);
        }
        return superResult;
    }

    private boolean checkBlocksByFeet() {
        BlockState blockRight;
        BlockState blockLeft;
        if (this.direction == 1) {
            BlockPos posLeft = new BlockPos(Mth.floor((double)this.getX()) + 1, Math.round((float)(this.getY() - 1.0)), Mth.floor((double)this.getZ()) + 1);
            BlockPos posRight = new BlockPos(Mth.floor((double)this.getX()) - 1, Math.round((float)(this.getY() - 1.0)), Mth.floor((double)this.getZ()) + 1);
            blockLeft = this.level().getBlockState(posLeft);
            blockRight = this.level().getBlockState(posRight);
        } else if (this.direction == 2) {
            BlockPos posLeft = new BlockPos(Mth.floor((double)this.getX()) - 1, Math.round((float)(this.getY() - 1.0)), Mth.floor((double)this.getZ()) + 1);
            BlockPos posRight = new BlockPos(Mth.floor((double)this.getX()) - 1, Math.round((float)(this.getY() - 1.0)), Mth.floor((double)this.getZ()) - 1);
            blockLeft = this.level().getBlockState(posLeft);
            blockRight = this.level().getBlockState(posRight);
        } else if (this.direction == 3) {
            BlockPos posLeft = new BlockPos(Mth.floor((double)this.getX()) - 1, Math.round((float)(this.getY() - 1.0)), Mth.floor((double)this.getZ()) - 1);
            BlockPos posRight = new BlockPos(Mth.floor((double)this.getX()) + 1, Math.round((float)(this.getY() - 1.0)), Mth.floor((double)this.getZ()) - 1);
            blockLeft = this.level().getBlockState(posLeft);
            blockRight = this.level().getBlockState(posRight);
        } else if (this.direction == 4) {
            BlockPos posLeft = new BlockPos(Mth.floor((double)this.getX()) + 1, Math.round((float)(this.getY() - 1.0)), Mth.floor((double)this.getZ()) - 1);
            BlockPos posRight = new BlockPos(Mth.floor((double)this.getX()) + 1, Math.round((float)(this.getY() - 1.0)), Mth.floor((double)this.getZ()) + 1);
            blockLeft = this.level().getBlockState(posLeft);
            blockRight = this.level().getBlockState(posRight);
        } else {
            return false;
        }
        return blockLeft.blocksMotion() || blockRight.blocksMotion();
    }

    private void spawnExplosionParticles(int amount) {
        for (int i = 0; i < amount; ++i) {
            float velocity = 0.25f;
            float yaw = (float)i * ((float)Math.PI * 2 / (float)amount);
            float vy = this.random.nextFloat() * 0.1f - 0.05f;
            float vx = 0.25f * Mth.cos((float)yaw);
            float vz = 0.25f * Mth.sin((float)yaw);
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY() + 1.0, this.getZ(), (double)vx, (double)vy, (double)vz);
        }
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DIRECTION, (Object)0);
        builder.define(DIALOGUE, (Object)0);
        builder.define(ANGRY, (Object)false);
        builder.define(DESIRES, (Object)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)((String)ConfigHandler.COMMON.MOBS.UMVUTHI.whichItem.get()))), ((Integer)ConfigHandler.COMMON.MOBS.UMVUTHI.howMany.get()).intValue()));
        builder.define(TRADED_PLAYERS, (Object)new CompoundTag());
        builder.define(HEALTH_LOST, (Object)Float.valueOf(0.0f));
        builder.define(MISBEHAVED_PLAYER, Optional.empty());
        builder.define(IS_TRADING, (Object)false);
    }

    public int getDirectionData() {
        return (Integer)this.getEntityData().get(DIRECTION);
    }

    public void setDirection(int direction) {
        this.getEntityData().set(DIRECTION, (Object)direction);
    }

    public int getWhichDialogue() {
        return (Integer)this.getEntityData().get(DIALOGUE);
    }

    public void setWhichDialogue(int dialogue) {
        this.getEntityData().set(DIALOGUE, (Object)dialogue);
    }

    public boolean getAngry() {
        return (Boolean)this.getEntityData().get(ANGRY);
    }

    public void setAngry(boolean angry) {
        this.getEntityData().set(ANGRY, (Object)angry);
    }

    public void setDesires(ItemStack stack) {
        this.getEntityData().set(DESIRES, (Object)stack);
    }

    public ItemStack getDesires() {
        return (ItemStack)this.getEntityData().get(DESIRES);
    }

    public void setTradedPlayersCompound(ListTag players) {
        CompoundTag compound = new CompoundTag();
        compound.put("players", (Tag)players);
        this.getEntityData().set(TRADED_PLAYERS, (Object)compound);
    }

    public Set<UUID> getTradedPlayers() {
        HashSet<UUID> tradedPlayers = new HashSet<UUID>();
        CompoundTag compound = (CompoundTag)this.getEntityData().get(TRADED_PLAYERS);
        ListTag players = compound.getList("players", 11);
        for (Tag player : players) {
            tradedPlayers.add(NbtUtils.loadUUID((Tag)player));
        }
        return tradedPlayers;
    }

    public float getHealthLost() {
        return ((Float)this.getEntityData().get(HEALTH_LOST)).floatValue();
    }

    public void setHealthLost(float amount) {
        this.getEntityData().set(HEALTH_LOST, (Object)Float.valueOf(amount));
    }

    public boolean doesItemSatisfyDesire(ItemStack stack) {
        return EntityUmvuthi.canPayFor(stack, this.getDesires());
    }

    public boolean fulfillDesire(Slot input) {
        ItemStack desires = this.getDesires();
        if (EntityUmvuthi.canPayFor(input.getItem(), desires)) {
            input.remove(desires.getCount());
            return true;
        }
        return false;
    }

    public boolean hasTradedWith(Player player) {
        return this.getTradedPlayers().contains(player.getGameProfile().getId());
    }

    public void rememberTrade(Player player) {
        CompoundTag compound = (CompoundTag)this.getEntityData().get(TRADED_PLAYERS);
        ListTag players = compound.getList("players", 11);
        players.add((Object)NbtUtils.createUUID((UUID)player.getGameProfile().getId()));
        compound.put("players", (Tag)players);
        this.getEntityData().set(TRADED_PLAYERS, (Object)compound);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("direction", this.getDirectionData());
        CompoundTag compoundTradedPlayers = (CompoundTag)this.getEntityData().get(TRADED_PLAYERS);
        ListTag players = compoundTradedPlayers.getList("players", 11);
        compound.put("players", (Tag)players);
        compound.putInt("HomePosX", this.getRestrictCenter().getX());
        compound.putInt("HomePosY", this.getRestrictCenter().getY());
        compound.putInt("HomePosZ", this.getRestrictCenter().getZ());
        compound.putFloat("healthLost", this.getHealthLost());
        if (this.getMisbehavedPlayerId() != null) {
            compound.putUUID("MisbehavedPlayer", this.getMisbehavedPlayerId());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        UUID uuid;
        super.readAdditionalSaveData(compound);
        this.setDirection(compound.getInt("direction"));
        ListTag players = compound.getList("players", 11);
        this.setTradedPlayersCompound(players);
        int i = compound.getInt("HomePosX");
        int j = compound.getInt("HomePosY");
        int k = compound.getInt("HomePosZ");
        this.restrictTo(new BlockPos(i, j, k), -1);
        this.setHealthLost(compound.getInt("healthLost"));
        if (compound.hasUUID("MisbehavedPlayer")) {
            uuid = compound.getUUID("MisbehavedPlayer");
        } else {
            String s = compound.getString("MisbehavedPlayer");
            uuid = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setMisbehavedPlayerId(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Nullable
    public UUID getMisbehavedPlayerId() {
        return ((Optional)this.entityData.get(MISBEHAVED_PLAYER)).orElse(null);
    }

    public void setMisbehavedPlayerId(@Nullable UUID p_184754_1_) {
        this.entityData.set(MISBEHAVED_PLAYER, Optional.ofNullable(p_184754_1_));
    }

    @Nullable
    public LivingEntity getMisbehavedPlayer() {
        try {
            UUID uuid = this.getMisbehavedPlayerId();
            return uuid == null ? null : this.level().getPlayerByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    protected void playStepSound(BlockPos pos, BlockState blockState) {
    }

    private int getTimeUntilSunstrike() {
        float damageRatio = 1.0f - this.getHealthRatio();
        if ((double)damageRatio > 0.6) {
            damageRatio = 0.6f;
        }
        return (int)(50.0f - damageRatio / 0.6f * 20.0f);
    }

    @Override
    public AbilityType<?, ?>[] getAbilities() {
        return new AbilityType[]{DIE_ABILITY, HURT_ABILITY, BELLY_ABILITY, TALK_ABILITY, SUNSTRIKE_ABILITY, SOLAR_FLARE_ABILITY, SPAWN_ABILITY, SPAWN_SUNBLOCKERS_ABILITY, SOLAR_BEAM_ABILITY, BLESS_ABILITY, SUPERNOVA_ABILITY, ROAR_ABILITY};
    }

    @Override
    public void die(DamageSource cause) {
        super.die(cause);
        List<EntityUmvuthana> umvuthana = this.getEntitiesNearby(EntityUmvuthana.class, 30.0, 20.0, 30.0, 30.0);
        for (EntityUmvuthana entityUmvuthana : umvuthana) {
            if (!entityUmvuthana.isUmvuthiDevoted()) continue;
            if (entityUmvuthana instanceof EntityUmvuthanaCrane) {
                ((EntityUmvuthanaCrane)entityUmvuthana).hasTriedOrSucceededTeleport = true;
            }
            entityUmvuthana.timeUntilDeath = this.random.nextInt(20);
        }
        super.die(cause);
    }

    public void setTrading(boolean trading) {
        this.entityData.set(IS_TRADING, (Object)trading);
    }

    public boolean isTrading() {
        return (Boolean)this.entityData.get(IS_TRADING);
    }

    public Player getCustomer() {
        return this.customer;
    }

    public void setCustomer(Player customer) {
        this.setTrading(customer != null);
        this.customer = customer;
    }

    public void openGUI(Player playerEntity) {
        this.setCustomer(playerEntity);
        MMCommon.PROXY.setReferencedMob((Entity)this);
        if (!this.level().isClientSide && this.getTarget() == null && this.isAlive()) {
            playerEntity.openMenu(new MenuProvider(){

                public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
                    return new ContainerUmvuthiTrade(id, EntityUmvuthi.this, playerInventory);
                }

                public Component getDisplayName() {
                    return EntityUmvuthi.this.getDisplayName();
                }
            });
        }
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.canTradeWith(player) && this.getTarget() == null && this.isAlive()) {
            this.openGUI(player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canTradeWith(Player player) {
        if (this.isTrading() || this.getHealth() <= 0.0f) {
            return false;
        }
        ItemStack headStack = (ItemStack)player.getInventory().armor.get(3);
        return headStack.getItem() instanceof UmvuthanaMask;
    }

    private static boolean canPayFor(ItemStack stack, ItemStack worth) {
        return stack.getItem() == worth.getItem() && stack.getCount() >= worth.getCount();
    }

    @Override
    public boolean hasBossBar() {
        return (Boolean)ConfigHandler.COMMON.MOBS.UMVUTHI.hasBossBar.get();
    }

    @Override
    public BossEvent.BossBarColor bossBarColor() {
        return BossEvent.BossBarColor.YELLOW;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return LootTableHandler.UMVUTHI;
    }

    @Override
    protected ConfigHandler.CombatConfig getCombatConfig() {
        return ConfigHandler.COMMON.MOBS.UMVUTHI.combatConfig;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData livingData) {
        List<Player> players;
        if (reason == MobSpawnType.SPAWN_EGG && !(players = this.getPlayersNearby(5.0, 5.0, 5.0, 5.0)).isEmpty()) {
            Player closestPlayer = players.get(0);
            float closestPlayerDist = 6.0f;
            for (Player player : players) {
                float thisDist;
                if (player.getMainHandItem().getItem() != ItemHandler.UMVUTHI_SPAWN_EGG.get() && player.getMainHandItem().getItem() != ItemHandler.UMVUTHI_SPAWN_EGG.get() || !((thisDist = this.distanceTo((Entity)player)) < closestPlayerDist)) continue;
                closestPlayer = player;
                closestPlayerDist = thisDist;
            }
            float angle = (float)this.getAngleBetweenEntities((Entity)this, (Entity)closestPlayer) + 225.0f;
            int direction = (int)(angle / 90.0f) % 4 + 1;
            this.setDirection(direction);
        }
        if (reason != MobSpawnType.STRUCTURE) {
            this.restrictTo(this.blockPosition(), -1);
        }
        return super.finalizeSpawn(world, difficulty, reason, livingData);
    }

    public boolean causeFallDamage(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public void push(double x, double y, double z) {
        super.push(0.0, y, 0.0);
    }

    @Override
    public boolean hasBossMusic() {
        return true;
    }

    @Override
    public BossMusic<?> getBossMusic() {
        return BossMusicPlayer.UMVUTHI_MUSIC;
    }

    @Override
    public boolean resetHealthOnPlayerRespawn() {
        return (Boolean)ConfigHandler.COMMON.MOBS.UMVUTHI.resetHealthWhenRespawn.get();
    }

    public static class SpawnFollowersAbility
    extends Ability<EntityUmvuthi> {
        private boolean spawnSunblockers;
        private static final RawAnimation SPAWN_STRIX_ANIM = RawAnimation.begin().then("spawn_strix", Animation.LoopType.PLAY_ONCE);

        public SpawnFollowersAbility(AbilityType abilityType, EntityUmvuthi user, boolean spawnSunblockers) {
            super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 6), new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 11), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 6), new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 11), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 6), new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 11)});
            this.spawnSunblockers = spawnSunblockers;
        }

        @Override
        public void start() {
            super.start();
            ++((EntityUmvuthi)this.getUser()).umvuthanaSpawnCount;
            ((EntityUmvuthi)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_UMVUTHANA_INHALE.get(), 1.2f, 0.5f);
            this.playAnimation(SPAWN_STRIX_ANIM);
        }

        @Override
        protected void beginSection(AbilitySection section) {
            super.beginSection(section);
            EntityUmvuthi entity = (EntityUmvuthi)this.getUser();
            if (section.sectionType == AbilitySection.AbilitySectionType.STARTUP) {
                ((EntityUmvuthi)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_UMVUTHANA_INHALE.get(), 1.2f, 0.5f);
                this.playAnimation(SPAWN_STRIX_ANIM);
            }
            if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE && !((EntityUmvuthi)this.getUser()).level().isClientSide()) {
                EntityUmvuthanaMinion umvuthana;
                entity.playSound((SoundEvent)MMSounds.ENTITY_UMVUTHI_BELLY.get(), 1.5f, 1.0f);
                entity.playSound((SoundEvent)MMSounds.ENTITY_UMVUTHANA_BLOWDART.get(), 1.5f, 0.5f);
                double angle = entity.yHeadRot;
                if (angle < 0.0) {
                    angle += 360.0;
                }
                if (angle - (double)entity.getYRot() > 70.0) {
                    angle = 70.0f + entity.getYRot();
                } else if (angle - (double)entity.getYRot() < -70.0) {
                    angle = -70.0f + entity.getYRot();
                }
                if (this.spawnSunblockers) {
                    umvuthana = new EntityUmvuthanaCrane((EntityType<? extends EntityUmvuthanaMinion>)((EntityType)EntityHandler.UMVUTHANA_CRANE.get()), entity.level());
                    ((EntityUmvuthanaCrane)umvuthana).hasTriedOrSucceededTeleport = false;
                } else {
                    umvuthana = new EntityUmvuthanaMinion((EntityType<? extends EntityUmvuthanaMinion>)((EntityType)EntityHandler.UMVUTHANA_MINION.get()), entity.level());
                }
                umvuthana.absMoveTo(entity.getX() + 2.0 * Math.sin(-angle * (Math.PI / 180)), entity.getY() + 2.5, entity.getZ() + 2.0 * Math.cos(-angle * (Math.PI / 180)), entity.yHeadRot, 0.0f);
                umvuthana.setActive(false);
                umvuthana.active = false;
                umvuthana.finalizeSpawn((ServerLevelAccessor)entity.getCommandSenderWorld(), entity.level().getCurrentDifficultyAt(umvuthana.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
                umvuthana.restrictTo(entity.getRestrictCenter(), 25);
                if (entity.getTeam() instanceof PlayerTeam) {
                    umvuthana.level().getScoreboard().addPlayerToTeam(umvuthana.getScoreboardName(), entity.getTeam());
                }
                entity.level().addFreshEntity((Entity)umvuthana);
                umvuthana.setDeltaMovement(0.7 * Math.sin(-angle * (Math.PI / 180)), 0.5, 0.7 * Math.cos(-angle * (Math.PI / 180)));
                if (!this.spawnSunblockers) {
                    umvuthana.setTarget(entity.getTarget());
                    if (entity.getTarget() instanceof Player) {
                        umvuthana.setMisbehavedPlayerId(entity.getTarget().getUUID());
                    }
                }
            }
        }

        @Override
        protected void endSection(AbilitySection section) {
            super.endSection(section);
            if (section.sectionType == AbilitySection.AbilitySectionType.RECOVERY && ((EntityUmvuthi)this.getUser()).targetDistance <= 6.0f && ((EntityUmvuthi)this.getUser()).getTarget() != null && !this.spawnSunblockers) {
                this.interrupt();
            }
        }
    }

    public static class SupernovaAbility
    extends Ability<EntityUmvuthi> {
        public static AbilitySection[] SECTION_TRACK = new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 44), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.ACTIVE, 40), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 16)};
        private static final RawAnimation SUPERNOVA_ANIM = RawAnimation.begin().then("supernova", Animation.LoopType.PLAY_ONCE);
        private static final ParticleComponent.KeyTrack superNovaKeyTrack1 = new ParticleComponent.KeyTrack(new float[]{0.0f, 25.0f, 32.0f, 0.0f}, new float[]{0.0f, 0.6f, 0.85f, 1.0f});
        private static final ParticleComponent.KeyTrack superNovaKeyTrack2 = ParticleComponent.KeyTrack.oscillate(0.0f, 7.0f, 24);

        public SupernovaAbility(AbilityType abilityType, EntityUmvuthi user) {
            super(abilityType, user, SECTION_TRACK);
        }

        @Override
        public void start() {
            super.start();
            ((EntityUmvuthi)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_SUPERNOVA_START.get(), 3.0f, 1.0f);
            this.playAnimation(SUPERNOVA_ANIM);
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getTicksInUse() == 30) {
                ((EntityUmvuthi)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_SUPERNOVA_BLACKHOLE.get(), 2.0f, 1.2f);
            }
            if (this.getTicksInUse() < 30) {
                List<LivingEntity> entities = ((EntityUmvuthi)this.getUser()).getEntityLivingBaseNearby(16.0, 16.0, 16.0, 16.0);
                for (LivingEntity inRange : entities) {
                    if (inRange instanceof LeaderSunstrikeImmune || inRange instanceof Player && ((Player)inRange).getAbilities().invulnerable) continue;
                    Vec3 diff = inRange.position().subtract(((EntityUmvuthi)this.getUser()).position().add(0.0, 3.0, 0.0));
                    diff = diff.normalize().scale(0.03);
                    inRange.setDeltaMovement(inRange.getDeltaMovement().subtract(diff));
                    if (!(inRange.getY() < ((EntityUmvuthi)this.getUser()).getY() + 3.0)) continue;
                    inRange.setDeltaMovement(inRange.getDeltaMovement().add(0.0, 0.075, 0.0));
                }
            }
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP) {
                ((EntityUmvuthi)this.getUser()).addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 2, 1, false, false));
            }
            if (this.getTicksInUse() == 40) {
                ((EntityUmvuthi)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_UMVUTHI_ROAR.get(), 3.0f, 1.0f);
            }
            if (this.getLevel().isClientSide) {
                SupernovaAbility.superNovaEffects(this, ((EntityUmvuthi)this.getUser()).betweenHandPos, this.getLevel());
            }
        }

        @Override
        protected void beginSection(AbilitySection section) {
            super.beginSection(section);
            if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE && !((EntityUmvuthi)this.getUser()).level().isClientSide) {
                Vec3 offset = new Vec3((double)1.1f, 0.0, 0.0);
                offset = offset.yRot((float)Math.toRadians(-((EntityUmvuthi)this.getUser()).getYRot() - 90.0f));
                EntitySuperNova superNova = new EntitySuperNova((EntityType<? extends EntitySuperNova>)((EntityType)EntityHandler.SUPER_NOVA.get()), ((EntityUmvuthi)this.getUser()).level(), (LivingEntity)this.getUser(), ((EntityUmvuthi)this.getUser()).getX() + offset.x, ((EntityUmvuthi)this.getUser()).getY() + 0.05, ((EntityUmvuthi)this.getUser()).getZ() + offset.z);
                ((EntityUmvuthi)this.getUser()).level().addFreshEntity((Entity)superNova);
            }
        }

        public static void superNovaEffects(Ability<?> activeAbility, Vec3[] pinLocation, Level level) {
            double value;
            int i;
            Player clientPlayer = MMCommon.PROXY.getLocalPlayer();
            if (clientPlayer == null) {
                return;
            }
            double distToCaster = activeAbility.getUser().position().distanceToSqr(clientPlayer.position());
            if (distToCaster < 1000.0) {
                Minecraft.getInstance().gameRenderer.darkenWorldAmount += 0.06f;
                if (Minecraft.getInstance().gameRenderer.darkenWorldAmount > 1.0f) {
                    Minecraft.getInstance().gameRenderer.darkenWorldAmount = 1.0f;
                }
            }
            if (pinLocation == null || pinLocation.length == 0 || pinLocation[0] == null) {
                return;
            }
            int ticksInUse = activeAbility.getTicksInUse();
            Object user = activeAbility.getUser();
            RandomSource random = user.getRandom();
            if (ticksInUse == 1) {
                AdvancedParticleBase.spawnParticle(level, ParticleHandler.SUN, user.getX(), user.getY(), user.getZ(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 33.0, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(pinLocation), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, superNovaKeyTrack1, false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, superNovaKeyTrack2, true)});
            }
            if (ticksInUse == 33) {
                AdvancedParticleBase.spawnParticle(level, ParticleHandler.SUN_NOVA, user.getX(), user.getY(), user.getZ(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 20.0, 1.0, 1.0, 1.0, 0.0, 1.0, 13.0, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(pinLocation), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{11.0f, 7.0f, 5.5f, 1.0f, 30.0f}, new float[]{0.0f, 0.15f, 0.8f, 0.89f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new ParticleComponent.KeyTrack(new float[]{0.0f, 1.0f, 1.0f, 0.0f}, new float[]{0.0f, 0.15f, 0.89f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.PARTICLE_ANGLE, ParticleComponent.KeyTrack.startAndEnd(0.0f, -6.0f), false)});
            }
            if (ticksInUse == 32) {
                AdvancedParticleBase.spawnParticle(level, ParticleHandler.FLARE, user.getX(), user.getY(), user.getZ(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, 1.0, 1.0, 1.0, 0.7, 1.0, 3.0, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(pinLocation), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, ParticleComponent.constant(-0.15f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 22.0f, 0.0f}, new float[]{0.0f, 0.2f, 1.0f}), false)});
            }
            if (ticksInUse > 30 && ticksInUse < 41) {
                for (i = 0; i < 6; ++i) {
                    float phaseOffset = random.nextFloat();
                    value = random.nextDouble() * 0.3 + 0.05;
                    AdvancedParticleBase.spawnParticle(level, ParticleHandler.PIXEL, pinLocation[0].x, pinLocation[0].y, pinLocation[0].z, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, value, value, value, 1.0, 1.0, 6.0, false, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 3.0f}, new float[]{0.0f, 0.2f}), false), new ParticleComponent.Orbit(pinLocation, ParticleComponent.KeyTrack.startAndEnd(0.0f + phaseOffset, -0.4f + phaseOffset), ParticleComponent.KeyTrack.startAndEnd(0.5f + random.nextFloat(), 0.0f), ParticleComponent.constant(0.0f), ParticleComponent.constant(0.0f), ParticleComponent.constant(0.0f), true)});
                }
            }
            if (ticksInUse > 1 && ticksInUse < 27) {
                for (i = 0; i < 6; ++i) {
                    Vec3 particlePos = new Vec3((double)(random.nextFloat() * 5.0f), 0.0, 0.0);
                    particlePos = particlePos.yRot((float)((double)(random.nextFloat() * 2.0f) * Math.PI));
                    particlePos = particlePos.xRot((float)((double)(random.nextFloat() * 2.0f) * Math.PI));
                    particlePos = particlePos.add(pinLocation[0]);
                    value = random.nextDouble() * 0.5 + 0.1;
                    AdvancedParticleBase.spawnParticle(level, ParticleHandler.PIXEL, particlePos.x, particlePos.y, particlePos.z, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, value, value, value, 1.0, 1.0, 7.0, false, true, new ParticleComponent[]{new ParticleComponent.Attractor(pinLocation, 1.1f, 1.0f, ParticleComponent.Attractor.EnumAttractorBehavior.EXPONENTIAL), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 3.5f}, new float[]{0.0f, 0.2f}), false)});
                }
            }
            float timeFrac = Math.min((float)ticksInUse / 20.0f, 1.0f);
            if (ticksInUse > 1 && ticksInUse < 25 && ticksInUse % (int)(4.0f * (1.0f - timeFrac) + 1.0f) == 0) {
                AdvancedParticleBase.spawnParticle(level, ParticleHandler.RING_SPARKS, user.getX(), user.getY(), user.getZ(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, random.nextFloat() * (float)Math.PI * 2.0f, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 6.0f + random.nextFloat() * 3.0f, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(pinLocation), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(10.0f + 20.0f * timeFrac * timeFrac + 10.0f * random.nextFloat() * timeFrac, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.0f, 0.7f), false)});
            }
            if (ticksInUse == 14) {
                AdvancedParticleBase.spawnParticle(level, ParticleHandler.FLARE, user.getX(), user.getY(), user.getZ(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 18.0, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(pinLocation), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, ParticleComponent.constant(-0.1f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 35.0f, 0.0f}, new float[]{0.0f, 0.8f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.Oscillator(-5.0f, 5.0f, 42.0f, 0.0f), true)});
            }
            if (ticksInUse == 32) {
                AdvancedParticleBase.spawnParticle(level, ParticleHandler.BURST_IN, user.getX(), user.getY(), user.getZ(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 1.0, 1.0, 10.0, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(pinLocation), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(25.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.0f, 1.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.Oscillator(-2.0f, 2.0f, 42.0f, 0.0f), true)});
            }
            if (ticksInUse == 44) {
                float scale = 85.0f;
                AdvancedParticleBase.spawnParticle(level, ParticleHandler.RING_BIG, pinLocation[0].x, pinLocation[0].y, pinLocation[0].z, 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 40.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f * scale, 0.59f * scale, 0.87f * scale, 0.974f * scale, 0.998f * scale, scale}, new float[]{0.0f, 0.2f, 0.4f, 0.6f, 0.8f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false)});
                scale = 120.0f;
                AdvancedParticleBase.spawnParticle(level, ParticleHandler.GLOW, pinLocation[0].x, pinLocation[0].y, pinLocation[0].z, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, 0.95, 0.9, 0.35, 1.0, 1.0, 40.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f * scale, 0.59f * scale, 0.87f * scale, 0.974f * scale, 0.998f * scale, scale}, new float[]{0.0f, 0.2f, 0.4f, 0.6f, 0.8f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false)});
            }
        }
    }

    public static class SolarFlareAbility
    extends Ability<EntityUmvuthi> {
        public static AbilitySection[] SECTION_TRACK = new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 12), new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 18)};
        private static final RawAnimation FLARE_ANIM = RawAnimation.begin().then("flare", Animation.LoopType.PLAY_ONCE);

        public SolarFlareAbility(AbilityType abilityType, EntityUmvuthi user) {
            super(abilityType, user, SECTION_TRACK);
        }

        @Override
        public void start() {
            super.start();
            ((EntityUmvuthi)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_UMVUTHI_BURST.get(), 1.7f, 1.5f);
            this.playAnimation(FLARE_ANIM);
        }

        @Override
        protected void beginSection(AbilitySection section) {
            super.beginSection(section);
            if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
                EntityUmvuthi entity = (EntityUmvuthi)this.getUser();
                float radius = 4.0f;
                List<LivingEntity> hit = entity.getEntityLivingBaseNearby(radius, 2.0f * radius, radius, radius);
                for (LivingEntity aHit : hit) {
                    if (aHit instanceof LeaderSunstrikeImmune) continue;
                    entity.doHurtTarget((Entity)aHit, 1.0f, 3.0f);
                    if (aHit.isInvulnerable() || aHit instanceof Player && ((Player)aHit).getAbilities().invulnerable) continue;
                    double knockback = 3.0;
                    double angle = entity.getAngleBetweenEntities((Entity)entity, (Entity)aHit);
                    double x = knockback * Math.cos(Math.toRadians(angle - 90.0));
                    double z = knockback * Math.sin(Math.toRadians(angle - 90.0));
                    aHit.setDeltaMovement(x, 0.3, z);
                    if (!(aHit instanceof ServerPlayer)) continue;
                    ((ServerPlayer)aHit).connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)aHit));
                }
            }
        }
    }

    public static class SolarBeamAbility
    extends Ability<EntityUmvuthi> {
        protected LivingEntity entityTarget;
        private EntitySolarBeam solarBeam;
        private static final RawAnimation SOLAR_BEAM_ANIM = RawAnimation.begin().then("solar_beam", Animation.LoopType.PLAY_ONCE);

        public SolarBeamAbility(AbilityType abilityType, EntityUmvuthi user) {
            super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 22), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.ACTIVE, 68), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 10)});
        }

        @Override
        public void start() {
            super.start();
            this.entityTarget = ((EntityUmvuthi)this.getUser()).getTarget();
            this.playAnimation(SOLAR_BEAM_ANIM);
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            float radius1 = 0.8f;
            EntityUmvuthi entity = (EntityUmvuthi)this.getUser();
            if (this.getTicksInUse() == 4 && !entity.level().isClientSide) {
                this.solarBeam = new EntitySolarBeam((EntityType<? extends EntitySolarBeam>)((EntityType)EntityHandler.SOLAR_BEAM.get()), ((EntityUmvuthi)this.getUser()).level(), (LivingEntity)entity, entity.getX() + (double)radius1 * Math.sin((double)(-entity.getYRot()) * Math.PI / 180.0), entity.getY() + 1.4, entity.getZ() + (double)radius1 * Math.cos((double)(-entity.getYRot()) * Math.PI / 180.0), (float)((double)(entity.yHeadRot + 90.0f) * Math.PI / 180.0), (float)((double)(-entity.getXRot()) * Math.PI / 180.0), 55);
                entity.level().addFreshEntity((Entity)this.solarBeam);
            }
            if (this.getTicksInUse() >= 22 && this.entityTarget != null) {
                entity.getLookControl().setLookAt(this.entityTarget.getX(), this.entityTarget.getY() + (double)(this.entityTarget.getBbHeight() / 2.0f), this.entityTarget.getZ(), 2.0f, 90.0f);
            }
        }
    }

    public static class SunstrikeAbility
    extends Ability<EntityUmvuthi> {
        private static int STARTUP_DURATION = 9;
        protected LivingEntity entityTarget;
        public double prevX;
        public double prevZ;
        private int newX;
        private int newZ;
        private int y;
        private static final RawAnimation SUN_STRIKE_ANIM = RawAnimation.begin().then("sun_strike", Animation.LoopType.PLAY_ONCE);

        public SunstrikeAbility(AbilityType abilityType, EntityUmvuthi user) {
            super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, STARTUP_DURATION), new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 12)});
        }

        @Override
        public void start() {
            super.start();
            this.entityTarget = ((EntityUmvuthi)this.getUser()).getTarget();
            if (this.entityTarget != null) {
                this.prevX = this.entityTarget.getX();
                this.prevZ = this.entityTarget.getZ();
            }
            this.playAnimation(SUN_STRIKE_ANIM);
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (!((EntityUmvuthi)this.getUser()).level().isClientSide()) {
                if (this.entityTarget == null) {
                    return;
                }
                if (this.getTicksInUse() == STARTUP_DURATION - 2) {
                    double dz;
                    double x = this.entityTarget.getX();
                    this.y = Mth.floor((double)(this.entityTarget.getY() - 1.0));
                    double z = this.entityTarget.getZ();
                    double vx = (x - this.prevX) / (double)STARTUP_DURATION;
                    double vz = (z - this.prevZ) / (double)STARTUP_DURATION;
                    int t = 38;
                    this.newX = Mth.floor((double)(x + vx * (double)t));
                    this.newZ = Mth.floor((double)(z + vz * (double)t));
                    double dx = (double)this.newX - ((EntityUmvuthi)this.getUser()).getX();
                    double dist2ToUmvuthi = dx * dx + (dz = (double)this.newZ - ((EntityUmvuthi)this.getUser()).getZ()) * dz;
                    if (dist2ToUmvuthi < 3.0) {
                        this.newX = Mth.floor((double)this.entityTarget.getX());
                        this.newZ = Mth.floor((double)this.entityTarget.getZ());
                    }
                    for (int i = 0; i < 5 && !((EntityUmvuthi)this.getUser()).level().canSeeSkyFromBelowWater(new BlockPos(this.newX, this.y, this.newZ)); ++i) {
                        ++this.y;
                    }
                }
                if (this.getTicksInUse() < STARTUP_DURATION - 2) {
                    ((EntityUmvuthi)this.getUser()).getLookControl().setLookAt((Entity)this.entityTarget, 30.0f, 30.0f);
                }
                if (this.getTicksInUse() >= STARTUP_DURATION - 2) {
                    ((EntityUmvuthi)this.getUser()).getLookControl().setLookAt((double)this.newX, (double)((float)this.y + this.entityTarget.getEyeHeight()), (double)this.newZ, 50.0f, 50.0f);
                }
            }
        }

        @Override
        protected void beginSection(AbilitySection section) {
            super.beginSection(section);
            if (!((EntityUmvuthi)this.getUser()).level().isClientSide() && section.sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
                ((EntityUmvuthi)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_UMVUTHI_ATTACK.get(), 1.4f, 1.0f);
                EntitySunstrike sunstrike = new EntitySunstrike((EntityType<? extends EntitySunstrike>)((EntityType)EntityHandler.SUNSTRIKE.get()), ((EntityUmvuthi)this.getUser()).level(), (LivingEntity)this.getUser(), this.newX, this.y, this.newZ);
                sunstrike.onSummon();
                ((EntityUmvuthi)this.getUser()).level().addFreshEntity((Entity)sunstrike);
            }
        }
    }
}

