/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy;

import com.bobmowzie.mowziesmobs.MMCommon;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoBone;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoModel;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.client.sound.IGeomancyRumbler;
import com.bobmowzie.mowziesmobs.datagen.MMBlockTags;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.capability.AbilityData;
import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityBlockSwapper;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.item.ItemEarthrendGauntlet;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class TunnelingAbility
extends PlayerAbility
implements IGeomancyRumbler {
    private int doubleTapTimer = 0;
    public boolean prevUnderground;
    public BlockState justDug = Blocks.DIRT.defaultBlockState();
    boolean underground = false;
    private float spinAmount = 0.0f;
    private float pitch = 0.0f;
    private int timeUnderground = 0;
    private int timeAboveGround = 0;
    private InteractionHand whichHand;
    private ItemStack gauntletStack;
    private boolean isRumbling;
    private static final RawAnimation FALL_ANIM = RawAnimation.begin().thenPlayAndHold("tunneling_fall");
    private static final RawAnimation DRILL_ANIM = RawAnimation.begin().thenLoop("tunneling_drill");

    public TunnelingAbility(AbilityType<Player, ? extends Ability> abilityType, Player user) {
        super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionInfinite(AbilitySection.AbilitySectionType.ACTIVE)});
    }

    @Override
    public void tickNotUsing() {
        super.tickNotUsing();
        if (this.doubleTapTimer > 0) {
            --this.doubleTapTimer;
        }
    }

    public void playGauntletAnimation() {
        if (this.getUser() != null && !this.getLevel().isClientSide() && this.gauntletStack != null && this.gauntletStack.getItem() == ItemHandler.EARTHREND_GAUNTLET.get()) {
            Player player = (Player)this.getUser();
            ((ItemEarthrendGauntlet)((Object)ItemHandler.EARTHREND_GAUNTLET.get())).triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)this.gauntletStack, (ServerLevel)((ServerLevel)player.level())), "controller", "open");
        }
    }

    public void stopGauntletAnimation() {
        if (this.getUser() != null && !this.getLevel().isClientSide() && this.gauntletStack != null && this.gauntletStack.getItem() == ItemHandler.EARTHREND_GAUNTLET.get()) {
            Player player = (Player)this.getUser();
            ((ItemEarthrendGauntlet)((Object)ItemHandler.EARTHREND_GAUNTLET.get())).triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)this.gauntletStack, (ServerLevel)((ServerLevel)player.level())), "controller", "idle");
        }
    }

    @Override
    public void start() {
        super.start();
        this.underground = false;
        this.prevUnderground = false;
        if (((Player)this.getUser()).onGround()) {
            ((Player)this.getUser()).push(0.0, (double)0.8f, 0.0);
        }
        this.whichHand = ((Player)this.getUser()).getUsedItemHand();
        this.gauntletStack = ((Player)this.getUser()).getUseItem();
        if (((Player)this.getUser()).level().isClientSide()) {
            this.spinAmount = 0.0f;
            this.pitch = 0.0f;
        }
        if (this.getLevel().isClientSide()) {
            MMCommon.PROXY.playGeomancyRumbleSound(this);
        }
    }

    public boolean damageGauntlet() {
        ItemStack stack = ((Player)this.getUser()).getUseItem();
        if (stack.getItem() == ItemHandler.EARTHREND_GAUNTLET.get()) {
            InteractionHand handIn = ((Player)this.getUser()).getUsedItemHand();
            if (stack.getDamageValue() + 5 < stack.getMaxDamage()) {
                stack.hurtAndBreak(5, this.getUser(), LivingEntity.getSlotForHand((InteractionHand)handIn));
                return true;
            }
            if (((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHREND_GAUNTLET.breakable.get()).booleanValue()) {
                stack.hurtAndBreak(5, this.getUser(), LivingEntity.getSlotForHand((InteractionHand)handIn));
            }
            return false;
        }
        return false;
    }

    public void restoreGauntlet(ItemStack stack) {
        if (stack.getItem() == ItemHandler.EARTHREND_GAUNTLET.get() && !((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHREND_GAUNTLET.breakable.get()).booleanValue()) {
            stack.setDamageValue(Math.max(stack.getDamageValue() - 1, 0));
        }
    }

    @Override
    public void tick() {
        super.tick();
        AbilityData data = DataHandler.getData(this.getUser(), DataHandler.ABILITY_DATA);
        if (data.getActiveAbility() == null || data.getActiveAbility().getAbilityType() != AbilityHandler.SPAWN_PILLAR_ABILITY && data.getActiveAbility().getAbilityType() != AbilityHandler.TUNNELING_ABILITY) {
            Player player = (Player)this.getUser();
            for (ItemStack stack : player.getInventory().items) {
                this.restoreGauntlet(stack);
            }
            for (ItemStack stack : player.getInventory().offhand) {
                this.restoreGauntlet(stack);
            }
        }
    }

    @Override
    public void tickUsing() {
        boolean usingGauntlet;
        super.tickUsing();
        ((Player)this.getUser()).getAbilities().flying = false;
        this.underground = !((Player)this.getUser()).level().getEntitiesOfClass(EntityBlockSwapper.EntityBlockSwapperTunneling.class, ((Player)this.getUser()).getBoundingBox().inflate(0.3)).isEmpty();
        Vec3 lookVec = ((Player)this.getUser()).getLookAngle();
        float tunnelSpeed = 0.3f;
        ItemStack stack = ((Player)this.getUser()).getUseItem();
        boolean bl = usingGauntlet = stack.getItem() == ItemHandler.EARTHREND_GAUNTLET.get();
        if (this.underground) {
            ++this.timeUnderground;
            if (usingGauntlet && this.damageGauntlet()) {
                ((Player)this.getUser()).setDeltaMovement(lookVec.normalize().scale((double)tunnelSpeed));
            } else {
                ((Player)this.getUser()).setDeltaMovement(lookVec.multiply(0.3, 0.0, 0.3).add(0.0, 1.0, 0.0).normalize().scale((double)tunnelSpeed));
            }
            List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby((LivingEntity)this.getUser(), 2.0, 2.0, 2.0, 2.0);
            for (LivingEntity entityHit : entitiesHit) {
                DamageSource damageSource = ((Player)this.getUser()).damageSources().playerAttack((Player)this.getUser());
                entityHit.hurt(damageSource, 3.0f * ((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHREND_GAUNTLET.attackMultiplier.get()).floatValue());
            }
        } else {
            ++this.timeAboveGround;
            ((Player)this.getUser()).setDeltaMovement(((Player)this.getUser()).getDeltaMovement().subtract(0.0, 0.07, 0.0));
            if (((Player)this.getUser()).getDeltaMovement().y() < -1.3) {
                ((Player)this.getUser()).setDeltaMovement(((Player)this.getUser()).getDeltaMovement().x(), -1.3, ((Player)this.getUser()).getDeltaMovement().z());
            }
        }
        if (this.underground && (this.prevUnderground || lookVec.y < 0.0) && this.timeAboveGround > 5 || this.getTicksInUse() > 1 && usingGauntlet && lookVec.y < 0.0 && stack.getDamageValue() + 5 < stack.getMaxDamage()) {
            Vec3 userCenter = ((Player)this.getUser()).position().add(0.0, (double)(((Player)this.getUser()).getBbHeight() / 2.0f), 0.0);
            float radius = 2.0f;
            AABB aabb = new AABB((double)(-radius), (double)(-radius), (double)(-radius), (double)radius, (double)radius, (double)radius);
            aabb = aabb.move(userCenter);
            int i = 0;
            while ((double)i < ((Player)this.getUser()).getDeltaMovement().length() * 4.0) {
                int x = (int)Math.floor(aabb.minX);
                while ((double)x <= Math.floor(aabb.maxX)) {
                    int y = (int)Math.floor(aabb.minY);
                    while ((double)y <= Math.floor(aabb.maxY)) {
                        int z = (int)Math.floor(aabb.minZ);
                        while ((double)z <= Math.floor(aabb.maxZ)) {
                            Vec3 posVec = new Vec3((double)x, (double)y, (double)z);
                            if (!(posVec.add(0.5, 0.5, 0.5).subtract(userCenter).lengthSqr() > (double)(radius * radius))) {
                                Vec3 motionScaled = ((Player)this.getUser()).getDeltaMovement().normalize().scale((double)i);
                                posVec = posVec.add(motionScaled);
                                BlockPos pos = new BlockPos((int)posVec.x, (int)posVec.y, (int)posVec.z);
                                BlockState blockState = ((Player)this.getUser()).level().getBlockState(pos);
                                if (EffectGeomancy.checkBlock(blockState, MMBlockTags.GEOMANCY_TUNNELABLE) && blockState.getBlock() != Blocks.BEDROCK) {
                                    this.justDug = blockState;
                                    if (!this.getLevel().isClientSide) {
                                        EntityBlockSwapper.EntityBlockSwapperTunneling swapper = new EntityBlockSwapper.EntityBlockSwapperTunneling((EntityType<? extends EntityBlockSwapper.EntityBlockSwapperTunneling>)((EntityType)EntityHandler.BLOCK_SWAPPER_TUNNELING.get()), this.getLevel(), pos, Blocks.AIR.defaultBlockState(), 15, false, false, (LivingEntity)this.getUser());
                                        this.getLevel().addFreshEntity((Entity)swapper);
                                    }
                                }
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++i;
            }
        }
        this.isRumbling = this.underground;
        if (!this.prevUnderground && this.underground) {
            this.timeUnderground = 0;
            ((Player)this.getUser()).playSound((SoundEvent)((DeferredHolder)MMSounds.EFFECT_GEOMANCY_BREAK_MEDIUM.get(this.rand.nextInt(3))).get(), 1.0f, 0.9f + this.rand.nextFloat() * 0.1f);
            if (((Player)this.getUser()).level().isClientSide) {
                AdvancedParticleBase.spawnParticle(((Player)this.getUser()).level(), ParticleHandler.RING2, (float)((Player)this.getUser()).getX(), (float)((Player)this.getUser()).getY() + 0.02f, (float)((Player)this.getUser()).getZ(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 10.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(10.0f, 30.0f), false)});
            }
            this.playGauntletAnimation();
        }
        if (this.prevUnderground && !this.underground) {
            this.timeAboveGround = 0;
            ((Player)this.getUser()).playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK.get(), 1.0f, 0.9f + this.rand.nextFloat() * 0.1f);
            if (((Player)this.getUser()).level().isClientSide) {
                AdvancedParticleBase.spawnParticle(((Player)this.getUser()).level(), ParticleHandler.RING2, (float)((Player)this.getUser()).getX(), (float)((Player)this.getUser()).getY() + 0.02f, (float)((Player)this.getUser()).getZ(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 10.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(10.0f, 30.0f), false)});
            }
            if (this.timeUnderground > 10) {
                ((Player)this.getUser()).setDeltaMovement(((Player)this.getUser()).getDeltaMovement().scale(10.0));
            } else {
                ((Player)this.getUser()).setDeltaMovement(((Player)this.getUser()).getDeltaMovement().multiply(3.0, 7.0, 3.0));
            }
            for (int i = 0; i < 6; ++i) {
                if (this.justDug == null) {
                    this.justDug = Blocks.DIRT.defaultBlockState();
                }
                EntityFallingBlock fallingBlock = new EntityFallingBlock((EntityType)EntityHandler.FALLING_BLOCK.get(), ((Player)this.getUser()).level(), 80, this.justDug);
                fallingBlock.setPos(((Player)this.getUser()).getX(), ((Player)this.getUser()).getY() + 1.0, ((Player)this.getUser()).getZ());
                fallingBlock.setDeltaMovement(((Player)this.getUser()).getRandom().nextFloat() * 0.8f - 0.4f, 0.4f + ((Player)this.getUser()).getRandom().nextFloat() * 0.8f, ((Player)this.getUser()).getRandom().nextFloat() * 0.8f - 0.4f);
                ((Player)this.getUser()).level().addFreshEntity((Entity)fallingBlock);
            }
            this.stopGauntletAnimation();
        }
        this.prevUnderground = this.underground;
    }

    @Override
    public void end() {
        super.end();
        this.stopGauntletAnimation();
    }

    @Override
    public boolean canUse() {
        return (Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHREND_GAUNTLET.enableTunneling.get() != false && super.canUse() && (Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHREND_GAUNTLET.enableTunneling.get() != false;
    }

    @Override
    protected boolean canContinueUsing() {
        boolean usingGauntlet;
        ItemStack stack = ((Player)this.getUser()).getUseItem();
        boolean bl = usingGauntlet = stack.getItem() == ItemHandler.EARTHREND_GAUNTLET.get();
        if (this.whichHand == null) {
            return false;
        }
        boolean canContinueUsing = (this.getTicksInUse() <= 1 || !((Player)this.getUser()).onGround() && (!((Player)this.getUser()).isInWater() || usingGauntlet) || this.underground) && ((Player)this.getUser()).getItemInHand(this.whichHand).getItem() == ItemHandler.EARTHREND_GAUNTLET.get() && super.canContinueUsing();
        return canContinueUsing;
    }

    @Override
    public boolean preventsItemUse(ItemStack stack) {
        if (stack.getItem() == ItemHandler.EARTHREND_GAUNTLET.get()) {
            return false;
        }
        return super.preventsItemUse(stack);
    }

    @Override
    public <E extends GeoEntity> PlayState animationPredicate(AnimationState<E> e, GeckoPlayer.Perspective perspective) {
        e.getController().transitionLength(4);
        if (perspective == GeckoPlayer.Perspective.THIRD_PERSON) {
            float yMotionThreshold;
            float f = yMotionThreshold = this.getUser() == MMCommon.PROXY.getLocalPlayer() ? 1.0f : 2.0f;
            if (!this.underground && ((Player)this.getUser()).getUseItem().getItem() != ItemHandler.EARTHREND_GAUNTLET.get() && ((Player)this.getUser()).getDeltaMovement().y() < (double)yMotionThreshold) {
                e.getController().setAnimation(FALL_ANIM);
            } else {
                e.getController().setAnimation(DRILL_ANIM);
            }
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void codeAnimations(MowzieGeoModel<? extends GeoEntity> model, float partialTick) {
        super.codeAnimations(model, partialTick);
        float faceMotionController = 1.0f - model.getControllerValueInverted("FaceVelocityController");
        Vec3 moveVec = ((Player)this.getUser()).getDeltaMovement().normalize();
        this.pitch = (float)Mth.lerp((double)(0.3 * (double)partialTick), (double)this.pitch, (double)moveVec.y());
        MowzieGeoBone com = model.getMowzieBone("CenterOfMass");
        com.setRotX((float)(-1.5707963267948966 + 1.5707963267948966 * (double)this.pitch) * faceMotionController);
        float spinSpeed = 0.35f;
        if (faceMotionController < 1.0f && (double)this.spinAmount < 6.2731853071795864 && (double)this.spinAmount > 0.01) {
            float f = (float)((Math.PI * 2 - (double)this.spinAmount) / (Math.PI * 2));
            f = (float)Math.pow(f, 0.5);
            this.spinAmount += partialTick * spinSpeed * f;
            if ((double)this.spinAmount > Math.PI * 2) {
                this.spinAmount = 0.0f;
            }
        } else {
            this.spinAmount += faceMotionController * partialTick * spinSpeed;
            this.spinAmount = (float)((double)this.spinAmount % (Math.PI * 2));
        }
        MowzieGeoBone waist = model.getMowzieBone("Waist");
        waist.addRotY(-this.spinAmount);
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag compound = super.writeNBT();
        if (this.isUsing() && this.whichHand != null) {
            compound.putInt("whichHand", this.whichHand.ordinal());
        }
        return compound;
    }

    @Override
    public void readNBT(Tag nbt) {
        super.readNBT(nbt);
        if (this.isUsing()) {
            CompoundTag compound = (CompoundTag)nbt;
            this.whichHand = InteractionHand.values()[compound.getInt("whichHand")];
        }
    }

    @Override
    public void onFall(LivingFallEvent event) {
        super.onFall(event);
        if (event.getEntity() == this.getUser() && this.isUsing()) {
            event.setDamageMultiplier(0.0f);
        }
    }

    @Override
    public boolean isRumbling() {
        return this.isRumbling && this.isUsing();
    }

    @Override
    public boolean isFinishedRumbling() {
        return !this.isUsing();
    }

    @Override
    public float getRumblerX() {
        return (float)((Player)this.getUser()).getX();
    }

    @Override
    public float getRumblerY() {
        return (float)((Player)this.getUser()).getY();
    }

    @Override
    public float getRumblerZ() {
        return (float)((Player)this.getUser()).getZ();
    }
}

