/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render;

import com.bobmowzie.mowziesmobs.client.model.tools.MathUtils;
import com.bobmowzie.mowziesmobs.client.model.tools.ModelPartMatrix;
import com.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;

public class MowzieRenderUtils {
    public static void matrixStackFromModel(PoseStack matrixStack, AdvancedModelRenderer modelRenderer) {
        AdvancedModelRenderer parent = modelRenderer.getParent();
        if (parent != null) {
            MowzieRenderUtils.matrixStackFromModel(matrixStack, parent);
        }
        modelRenderer.translateRotate(matrixStack);
    }

    public static Vec3 getWorldPosFromModel(Entity entity, float entityYaw, AdvancedModelRenderer modelRenderer) {
        PoseStack matrixStack = new PoseStack();
        matrixStack.translate(entity.getX(), entity.getY(), entity.getZ());
        matrixStack.mulPose(MathUtils.quatFromRotationXYZ(0.0f, -entityYaw + 180.0f, 0.0f, true));
        matrixStack.scale(-1.0f, -1.0f, 1.0f);
        matrixStack.translate(0.0f, -1.5f, 0.0f);
        MowzieRenderUtils.matrixStackFromModel(matrixStack, modelRenderer);
        PoseStack.Pose matrixEntry = matrixStack.last();
        Matrix4f matrix4f = matrixEntry.pose();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.mul((Matrix4fc)matrix4f);
        return new Vec3((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    public static void translateRotateGeckolib(GeoBone bone, PoseStack matrixStackIn) {
        matrixStackIn.translate((double)(bone.getPivotX() / 16.0f), (double)(bone.getPivotY() / 16.0f), (double)(bone.getPivotZ() / 16.0f));
        if (bone.getRotZ() != 0.0f) {
            matrixStackIn.mulPose(Axis.ZP.rotation(bone.getRotZ()));
        }
        if (bone.getRotY() != 0.0f) {
            matrixStackIn.mulPose(Axis.YP.rotation(bone.getRotY()));
        }
        if (bone.getRotX() != 0.0f) {
            matrixStackIn.mulPose(Axis.XP.rotation(bone.getRotX()));
        }
        matrixStackIn.scale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void matrixStackFromModel(PoseStack matrixStack, GeoBone geoBone) {
        GeoBone parent = geoBone.getParent();
        if (parent != null) {
            MowzieRenderUtils.matrixStackFromModel(matrixStack, parent);
        }
        MowzieRenderUtils.translateRotateGeckolib(geoBone, matrixStack);
    }

    public static Vec3 getWorldPosFromModel(Entity entity, float entityYaw, GeoBone geoBone) {
        PoseStack matrixStack = new PoseStack();
        matrixStack.translate(entity.getX(), entity.getY(), entity.getZ());
        matrixStack.mulPose(MathUtils.quatFromRotationXYZ(0.0f, -entityYaw + 180.0f, 0.0f, true));
        matrixStack.scale(-1.0f, -1.0f, 1.0f);
        matrixStack.translate(0.0f, -1.5f, 0.0f);
        MowzieRenderUtils.matrixStackFromModel(matrixStack, geoBone);
        PoseStack.Pose matrixEntry = matrixStack.last();
        Matrix4f matrix4f = matrixEntry.pose();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.mul((Matrix4fc)matrix4f);
        return new Vec3((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    public static void moveToPivotMirror(PoseStack stack, GeoCube cube) {
        Vec3 pivot = cube.pivot();
        stack.translate(-pivot.x() / 16.0, pivot.y() / 16.0, pivot.z() / 16.0);
    }

    public static void translateAwayFromPivotPointMirror(PoseStack stack, GeoCube cube) {
        Vec3 pivot = cube.pivot();
        stack.translate(pivot.x() / 16.0, -pivot.y() / 16.0, -pivot.z() / 16.0);
    }

    public static void moveToPivotMirror(PoseStack stack, GeoBone bone) {
        stack.translate((double)(-bone.getPivotX() / 16.0f), (double)(bone.getPivotY() / 16.0f), (double)(bone.getPivotZ() / 16.0f));
    }

    public static void translateAwayFromPivotPointMirror(PoseStack stack, GeoBone bone) {
        stack.translate((double)(bone.getPivotX() / 16.0f), (double)(-bone.getPivotY() / 16.0f), (double)(-bone.getPivotZ() / 16.0f));
    }

    public static void translateMirror(PoseStack stack, GeoBone bone) {
        stack.translate((double)(bone.getPosX() / 16.0f), (double)(bone.getPosY() / 16.0f), (double)(bone.getPosZ() / 16.0f));
    }

    public static void rotateMirror(PoseStack stack, GeoBone bone) {
        if (bone.getRotZ() != 0.0f) {
            stack.mulPose(Axis.ZP.rotation(-bone.getRotZ()));
        }
        if (bone.getRotY() != 0.0f) {
            stack.mulPose(Axis.YP.rotation(-bone.getRotY()));
        }
        if (bone.getRotX() != 0.0f) {
            stack.mulPose(Axis.XP.rotation(bone.getRotX()));
        }
    }

    public static void transformStackToModelPart(PoseStack stack, ModelPartMatrix part) {
        stack.last().pose().identity();
        stack.last().normal().identity();
        stack.pushPose();
        stack.last().pose().mul((Matrix4fc)part.getWorldXform());
        stack.last().normal().mul((Matrix3fc)part.getWorldNormal());
    }
}

