/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.leaves;

import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.VanillaLeavesTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import org.jetbrains.annotations.Nullable;

public class LeavesTypeRegistry
extends BlockTypeRegistry<LeavesType> {
    public static final LeavesTypeRegistry INSTANCE = new LeavesTypeRegistry();
    @Deprecated(forRemoval=true)
    public static LeavesType OAK_TYPE = VanillaLeavesTypes.OAK;
    private final Map<ResourceLocation, ResourceLocation> specialLeavesToWood = new HashMap<ResourceLocation, ResourceLocation>();
    private final Map<LeavesType, WoodType> leavesToWood = new IdentityHashMap<LeavesType, WoodType>();

    @Deprecated(forRemoval=true)
    public static Collection<LeavesType> getTypes() {
        return INSTANCE.getValues();
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static LeavesType getValue(ResourceLocation leavesTypeId) {
        return (LeavesType)INSTANCE.get(leavesTypeId);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static LeavesType getValue(String leavesTypeId) {
        return (LeavesType)INSTANCE.get(ResourceLocation.parse((String)leavesTypeId));
    }

    @Deprecated(forRemoval=true)
    public static LeavesType fromNBT(String name) {
        return (LeavesType)INSTANCE.getFromNBT(name);
    }

    public LeavesTypeRegistry() {
        super(LeavesType.class, "leaves_type");
        LeavesType.CODEC = this.getCodec();
        LeavesType.STREAM_CODEC = this.getStreamCodecExplicit();
    }

    static void touch() {
    }

    @Override
    protected LeavesType register(LeavesType vanillaType) {
        return super.register(vanillaType);
    }

    @Override
    public LeavesType getDefaultType() {
        return VanillaLeavesTypes.OAK;
    }

    @Nullable
    public WoodType getEquivalentWoodType(LeavesType leavesType) {
        return this.leavesToWood.get(leavesType);
    }

    @Override
    public Optional<LeavesType> detectTypeFromBlock(Block baseBlock, ResourceLocation baseId) {
        ResourceLocation id;
        String name = null;
        String path = baseId.getPath();
        if (path.endsWith("_leaves")) {
            name = path.substring(0, path.length() - "_leaves".length());
        } else if (path.startsWith("leaves_")) {
            name = path.substring("leaves_".length());
        }
        String namespace = baseId.getNamespace();
        if (name != null && !namespace.equals("securitycraft") && !path.contains("hanging") && baseBlock instanceof LeavesBlock && !this.valuesReg.containsKey(id = baseId.withPath(name))) {
            return Optional.of(new LeavesType(id, baseBlock));
        }
        return Optional.empty();
    }

    private static boolean isBlacklisted(String namespace, String path) {
        return namespace.equals("securitycraft") || namespace.equals("dynamic_trees") || namespace.matches("dynamictrees|dt\\w+") || path.contains("hanging");
    }

    @Override
    public void finalizeAndFreeze() {
        super.finalizeAndFreeze();
        for (LeavesType l : this.getValues()) {
            ResourceLocation leavesId = l.id;
            ResourceLocation id = this.specialLeavesToWood.getOrDefault(leavesId, leavesId);
            WoodType o = (WoodType)WoodTypeRegistry.INSTANCE.get(id);
            String path = id.getPath();
            String namespace = id.getNamespace();
            if (o == null) {
                for (WoodType w : WoodTypeRegistry.INSTANCE.getValues()) {
                    if (!w.id.getPath().equals(path)) continue;
                    o = w;
                    break;
                }
            }
            if (o == null) {
                for (WoodType w : WoodTypeRegistry.INSTANCE.getValues()) {
                    if (!w.isVanilla() && !w.id.getNamespace().equals(namespace) || !path.endsWith(w.id.getPath())) continue;
                    o = w;
                }
            }
            if (o == null) continue;
            this.leavesToWood.put(l, o);
        }
    }

    public void addLeavesToWoodMapping(ResourceLocation leavesTypeId, ResourceLocation woodTypeId) {
        this.specialLeavesToWood.put(leavesTypeId, woodTypeId);
    }

    public void addLeavesToWoodMapping(String leavedId, String woodId) {
        this.addLeavesToWoodMapping(ResourceLocation.parse((String)leavedId), ResourceLocation.parse((String)woodId));
    }

    public void addLeavesToWoodMapping(String modId, String leavesTypeName, String woodTypeName) {
        this.addLeavesToWoodMapping(ResourceLocation.fromNamespaceAndPath((String)modId, (String)leavesTypeName), ResourceLocation.fromNamespaceAndPath((String)modId, (String)woodTypeName));
    }

    @Override
    public int priority() {
        return 99;
    }

    public LeavesType.Finder addSimpleFinder(ResourceLocation typeId) {
        LeavesType.Finder finder = new LeavesType.Finder(typeId);
        this.addFinder(finder);
        return finder;
    }

    public LeavesType.Finder addSimpleFinder(String typeId) {
        return this.addSimpleFinder(ResourceLocation.parse((String)typeId));
    }

    public LeavesType.Finder addSimpleFinder(String namespace, String name) {
        return this.addSimpleFinder(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)name));
    }
}

