/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.google.common.collect.ImmutableList;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.client.model.properties.ModProperties;
import com.ldtteam.domumornamentum.entity.block.IMateriallyTexturedBlockEntity;
import com.ldtteam.structurize.blueprints.v1.DataFixerUtils;
import com.ldtteam.structurize.blueprints.v1.DataVersion;
import com.minecolonies.api.blocks.AbstractBlockMinecoloniesRack;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.blocks.types.RackType;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.inventory.api.CombinedItemHandler;
import com.minecolonies.api.inventory.container.ContainerRack;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import com.mojang.datafixers.DSL;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityRack
extends AbstractTileEntityRack
implements IMateriallyTexturedBlockEntity {
    private static final byte VERSION = 2;
    private byte version = 0;
    private final Object2IntMap<ItemStorage> content = new Object2IntOpenHashMap();
    private int size = 0;
    private int freeSlots = 0;
    private IItemHandler lastItemHandlerCap;
    private static final List<ResourceLocation> textureMapping = ImmutableList.builder().add((Object)ResourceLocation.withDefaultNamespace((String)"block/bricks")).add((Object)ResourceLocation.withDefaultNamespace((String)"block/sand")).add((Object)ResourceLocation.withDefaultNamespace((String)"block/orange_wool")).add((Object)ResourceLocation.withDefaultNamespace((String)"block/dirt")).add((Object)ResourceLocation.withDefaultNamespace((String)"block/obsidian")).add((Object)ResourceLocation.withDefaultNamespace((String)"block/polished_andesite")).add((Object)ResourceLocation.withDefaultNamespace((String)"block/andesite")).add((Object)ResourceLocation.withDefaultNamespace((String)"block/blue_wool")).build();
    private static final List<ResourceLocation> secondarytextureMapping = ImmutableList.builder().add((Object)ResourceLocation.withDefaultNamespace((String)"block/oak_log")).add((Object)ResourceLocation.withDefaultNamespace((String)"block/spruce_log")).add((Object)ResourceLocation.withDefaultNamespace((String)"block/birch_log")).add((Object)ResourceLocation.withDefaultNamespace((String)"block/jungle_log")).add((Object)ResourceLocation.withDefaultNamespace((String)"block/acacia_log")).add((Object)ResourceLocation.withDefaultNamespace((String)"block/dark_oak_log")).add((Object)ResourceLocation.withDefaultNamespace((String)"block/mangrove_log")).add((Object)ResourceLocation.withDefaultNamespace((String)"block/crimson_stem")).build();
    private MaterialTextureData textureDataCache = new MaterialTextureData(Map.of());
    private boolean checkedAfterStartup = false;

    public TileEntityRack(BlockEntityType<? extends TileEntityRack> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.freeSlots = this.inventory.getSlots();
    }

    public TileEntityRack(BlockEntityType<? extends TileEntityRack> type, BlockPos pos, BlockState state, int size) {
        super(type, pos, state, size);
        this.size = (size - 27) / 9;
        this.freeSlots = this.inventory.getSlots();
    }

    public TileEntityRack(BlockPos pos, BlockState state) {
        super((BlockEntityType)MinecoloniesTileEntities.RACK.get(), pos, state);
    }

    @Override
    public void setInWarehouse(Boolean isInWarehouse) {
        this.inWarehouse = isInWarehouse;
    }

    @Override
    public int getFreeSlots() {
        return this.freeSlots;
    }

    @Override
    public boolean hasItemStack(ItemStack stack, int count, boolean ignoreDamageValue) {
        ItemStorage checkItem = new ItemStorage(stack, ignoreDamageValue);
        return this.content.getOrDefault((Object)checkItem, 0) >= count;
    }

    @Override
    public boolean hasItemStorage(ItemStorage storage, int count) {
        return this.content.getOrDefault((Object)storage, 0) >= count;
    }

    @Override
    public int getCount(ItemStack stack, boolean ignoreDamageValue, boolean ignoreNBT) {
        ItemStorage checkItem = new ItemStorage(stack, ignoreDamageValue, ignoreNBT);
        return this.getCount(checkItem);
    }

    @Override
    protected void updateBlockState() {
    }

    @Override
    public int getCount(ItemStorage storage) {
        if (storage.ignoreDamageValue() || storage.ignoreNBT()) {
            if (!this.content.containsKey((Object)storage)) {
                return 0;
            }
            int count = 0;
            for (Map.Entry contentStorage : this.content.entrySet()) {
                if (!((ItemStorage)contentStorage.getKey()).equals(storage)) continue;
                count += ((Integer)contentStorage.getValue()).intValue();
            }
            return count;
        }
        return this.content.getOrDefault((Object)storage, 0);
    }

    @Override
    public boolean hasItemStack(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        for (Map.Entry entry : this.content.entrySet()) {
            if (!itemStackSelectionPredicate.test(((ItemStorage)entry.getKey()).getItemStack())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSimilarStack(@NotNull ItemStack stack) {
        ItemStorage checkItem = new ItemStorage(stack, true, true);
        if (this.content.containsKey((Object)checkItem)) {
            return true;
        }
        for (ItemStorage storage : this.content.keySet()) {
            if (IColonyManager.getInstance().getCompatibilityManager().getCreativeTab(checkItem) != IColonyManager.getInstance().getCompatibilityManager().getCreativeTab(storage)) continue;
            return true;
        }
        return false;
    }

    public Map<ItemStorage, Integer> getAllContent() {
        return this.content;
    }

    @Override
    public void upgradeRackSize() {
        ++this.size;
        AbstractTileEntityRack.RackInventory tempInventory = new AbstractTileEntityRack.RackInventory(this, 27 + this.size * 9);
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            tempInventory.setStackInSlot(slot, this.inventory.getStackInSlot(slot));
        }
        this.inventory = tempInventory;
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        this.invalidateCap();
    }

    @Override
    public int getItemCount(Predicate<ItemStack> predicate) {
        int matched = 0;
        for (Map.Entry entry : this.content.entrySet()) {
            if (!predicate.test(((ItemStorage)entry.getKey()).getItemStack())) continue;
            matched += ((Integer)entry.getValue()).intValue();
        }
        return matched;
    }

    @Override
    public void updateItemStorage() {
        if (this.level != null && !this.level.isClientSide) {
            boolean beforeEmpty = this.content.isEmpty();
            this.updateContent();
            if (this.getBlockState().getBlock() == ModBlocks.blockRack) {
                boolean afterEmpty = this.content.isEmpty();
                AbstractTileEntityRack potentialNeighbor = this.getOtherChest();
                if (potentialNeighbor instanceof TileEntityRack && !((TileEntityRack)potentialNeighbor).isEmpty()) {
                    afterEmpty = false;
                }
                if (beforeEmpty && !afterEmpty || !beforeEmpty && afterEmpty) {
                    this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)((RackType)((Object)this.getBlockState().getValue(AbstractBlockMinecoloniesRack.VARIANT))).getInvBasedVariant(afterEmpty))));
                    if (potentialNeighbor != null) {
                        this.level.setBlockAndUpdate(potentialNeighbor.getBlockPos(), (BlockState)potentialNeighbor.getBlockState().setValue(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)((RackType)((Object)potentialNeighbor.getBlockState().getValue(AbstractBlockMinecoloniesRack.VARIANT))).getInvBasedVariant(afterEmpty))));
                    }
                }
            }
            this.setChanged();
        }
    }

    private void updateContent() {
        this.content.clear();
        this.freeSlots = 0;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (ItemStackUtils.isEmpty(stack)) {
                ++this.freeSlots;
                continue;
            }
            ItemStorage storage = new ItemStorage(stack.copy());
            int amount = ItemStackUtils.getSize(stack);
            if (this.content.containsKey((Object)storage)) {
                amount += this.content.remove((Object)storage).intValue();
            }
            this.content.put((Object)storage, amount);
        }
    }

    @Override
    public AbstractTileEntityRack getOtherChest() {
        if (this.getBlockState().getBlock() != ModBlocks.blockRack) {
            return null;
        }
        RackType type = (RackType)((Object)this.getBlockState().getValue(AbstractBlockMinecoloniesRack.VARIANT));
        if (!type.isDoubleVariant()) {
            return null;
        }
        BlockEntity tileEntity = this.level.getBlockEntity(this.worldPosition.relative((Direction)this.getBlockState().getValue((Property)AbstractBlockMinecoloniesRack.FACING)));
        if (tileEntity instanceof TileEntityRack && !(tileEntity instanceof AbstractTileEntityColonyBuilding)) {
            return (AbstractTileEntityRack)tileEntity;
        }
        return null;
    }

    @Override
    public ItemStackHandler createInventory(int slots) {
        return new AbstractTileEntityRack.RackInventory(this, slots);
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public void loadAdditional(CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.contains("tagSIze")) {
            this.size = compound.getInt("tagSIze");
            this.inventory = this.createInventory(27 + this.size * 9);
        }
        ListTag inventoryTagList = compound.getList("inventory", 10);
        for (int i = 0; i < inventoryTagList.size(); ++i) {
            CompoundTag compoundTag = inventoryTagList.getCompound(i);
            if (compoundTag.contains("empty")) continue;
            if (compoundTag.contains("Count")) {
                CompoundTag fixedTag = DataFixerUtils.runDataFixer((CompoundTag)compoundTag, (DSL.TypeReference)References.ITEM_STACK, (DataVersion)DataVersion.v1_20_1);
                this.inventory.setStackInSlot(i, ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)fixedTag));
                continue;
            }
            this.inventory.setStackInSlot(i, ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compoundTag));
        }
        this.updateContent();
        this.inWarehouse = compound.getBoolean("inWarehouse");
        if (compound.contains("pos")) {
            this.buildingPos = BlockPosUtil.read(compound, "pos");
        }
        this.version = compound.getByte("version");
        this.invalidateCap();
        if (this.level != null && this.level.isClientSide) {
            this.refreshTextureCache();
        }
    }

    public void saveAdditional(CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("tagSIze", this.size);
        @NotNull ListTag inventoryTagList = new ListTag();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            inventoryTagList.add((Object)this.inventory.getStackInSlot(slot).saveOptional(provider));
        }
        compound.put("inventory", (Tag)inventoryTagList);
        compound.putBoolean("inWarehouse", this.inWarehouse);
        BlockPosUtil.write(compound, "pos", this.buildingPos);
        compound.putByte("version", this.version);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        return this.saveWithId(provider);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, @NotNull HolderLookup.Provider provider) {
        this.loadAdditional(packet.getTag(), provider);
    }

    public void handleUpdateTag(CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        this.loadAdditional(tag, provider);
    }

    @Override
    @Nullable
    public IItemHandler getItemHandlerCap(Direction direction) {
        if (this.version != 2) {
            this.version = (byte)2;
        }
        if (this.remove) {
            this.lastItemHandlerCap = new AbstractTileEntityRack.RackInventory(this, 0);
        }
        if (this.lastItemHandlerCap != null) {
            return this.lastItemHandlerCap;
        }
        if (this.getBlockState().getBlock() != ModBlocks.blockRack) {
            this.lastItemHandlerCap = new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", this.getInventory());
            return this.lastItemHandlerCap;
        }
        RackType type = (RackType)((Object)this.getBlockState().getValue(AbstractBlockMinecoloniesRack.VARIANT));
        if (!type.isDoubleVariant()) {
            this.lastItemHandlerCap = new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", this.getInventory());
            return this.lastItemHandlerCap;
        }
        AbstractTileEntityRack other = this.getOtherChest();
        this.lastItemHandlerCap = other == null ? new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", this.getInventory()) : (type != RackType.EMPTY ? new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", this.getInventory(), other.getInventory()) : new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", other.getInventory(), this.getInventory()));
        return this.lastItemHandlerCap;
    }

    @Override
    public int getUpgradeSize() {
        return this.size;
    }

    public void setChanged() {
        if (this.level != null) {
            WorldUtil.markChunkDirty(this.level, this.worldPosition);
            super.setChanged();
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
        this.refreshTextureCache();
        return new ContainerRack(id, inv, this.getBlockPos(), this.getOtherChest() == null ? BlockPos.ZERO : this.getOtherChest().getBlockPos());
    }

    @NotNull
    public Component getDisplayName() {
        return Component.literal((String)"Rack");
    }

    public void setRemoved() {
        super.setRemoved();
        this.invalidateCap();
    }

    private void invalidateCap() {
        this.invalidateCapabilities();
        this.lastItemHandlerCap = null;
    }

    public void updateTextureDataWith(MaterialTextureData materialTextureData) {
    }

    private void refreshTextureCache() {
        HashMap<ResourceLocation, Block> resMap = new HashMap<ResourceLocation, Block>();
        int displayPerSlots = this.getInventory().getSlots() / 4;
        int index = 0;
        boolean update = false;
        boolean alreadyAddedItem = false;
        HashMap<ItemStorage, Integer> mapCopy = new HashMap<ItemStorage, Integer>((Map<ItemStorage, Integer>)this.content);
        AbstractTileEntityRack abstractTileEntityRack = this.getOtherChest();
        if (abstractTileEntityRack instanceof TileEntityRack) {
            TileEntityRack neighborRack = (TileEntityRack)abstractTileEntityRack;
            for (Map.Entry entry : neighborRack.content.entrySet()) {
                int value = (Integer)entry.getValue() + mapCopy.getOrDefault(entry.getKey(), 0);
                mapCopy.put((ItemStorage)entry.getKey(), value);
            }
        }
        List list = mapCopy.entrySet().stream().sorted((e1, e2) -> Integer.compare((Integer)e2.getValue(), (Integer)e1.getValue())).toList();
        ArrayDeque<Object> extraBlockQueue = new ArrayDeque<Object>();
        ArrayDeque<Block> itemQueue = new ArrayDeque<Block>();
        for (Map.Entry entry : list) {
            int displayRows;
            if (index >= textureMapping.size()) break;
            Block block = Blocks.BARREL;
            boolean isBlockItem = false;
            Item item = ((ItemStorage)entry.getKey()).getItemStack().getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                block = blockItem.getBlock();
                isBlockItem = true;
            }
            if ((displayRows = (int)Math.ceil(Math.max(1.0, (double)((Integer)entry.getValue()).intValue() / (double)((ItemStorage)entry.getKey()).getItemStack().getMaxStackSize()) / (double)displayPerSlots)) > 1) {
                for (int i = 0; i < displayRows - 1; ++i) {
                    if (isBlockItem) {
                        extraBlockQueue.add(block);
                        continue;
                    }
                    itemQueue.add(block);
                }
            }
            if (!isBlockItem) {
                if (alreadyAddedItem) {
                    itemQueue.add(block);
                    continue;
                }
                alreadyAddedItem = true;
            }
            if ((Integer)entry.getValue() < 16 && !extraBlockQueue.isEmpty()) {
                block = (Block)extraBlockQueue.poll();
            }
            ResourceLocation secondaryResLoc = secondarytextureMapping.get(index);
            if (!block.defaultBlockState().isSolidRender((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO)) {
                resMap.put(secondaryResLoc, block);
                block = Blocks.BARREL;
            } else {
                resMap.put(secondaryResLoc, Blocks.AIR);
            }
            ResourceLocation resLoc = textureMapping.get(index);
            resMap.put(resLoc, block);
            if (this.textureDataCache == null || !this.textureDataCache.getTexturedComponents().getOrDefault(resLoc, Blocks.BEDROCK).equals(resMap.get(resLoc)) || !this.textureDataCache.getTexturedComponents().getOrDefault(secondaryResLoc, Blocks.BEDROCK).equals(resMap.get(secondaryResLoc))) {
                update = true;
            }
            ++index;
        }
        extraBlockQueue.addAll(itemQueue);
        for (int i = index; i < textureMapping.size(); ++i) {
            Block block = Blocks.AIR;
            if (!extraBlockQueue.isEmpty()) {
                block = (Block)extraBlockQueue.poll();
            }
            ResourceLocation secondaryResLoc = secondarytextureMapping.get(i);
            if (block != Blocks.AIR && !block.defaultBlockState().isSolidRender((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO)) {
                resMap.put(secondaryResLoc, block);
                block = Blocks.BARREL;
            } else {
                resMap.put(secondaryResLoc, Blocks.AIR);
            }
            ResourceLocation resLoc = textureMapping.get(i);
            resMap.put(resLoc, block);
            if (this.textureDataCache != null && this.textureDataCache.getTexturedComponents().getOrDefault(resLoc, Blocks.BEDROCK).equals(resMap.get(resLoc)) && this.textureDataCache.getTexturedComponents().getOrDefault(secondaryResLoc, Blocks.BEDROCK).equals(resMap.get(secondaryResLoc))) continue;
            update = true;
        }
        if (update) {
            this.textureDataCache = new MaterialTextureData(resMap);
            this.requestModelDataUpdate();
            if (this.level != null) {
                this.level.sendBlockUpdated(this.getBlockPos(), Blocks.AIR.defaultBlockState(), this.getBlockState(), 3);
            }
        }
    }

    @NotNull
    public ModelData getModelData() {
        if (!this.checkedAfterStartup && this.level != null) {
            this.checkedAfterStartup = true;
            this.refreshTextureCache();
        }
        return ModelData.builder().with(ModProperties.MATERIAL_TEXTURE_PROPERTY, (Object)this.textureDataCache).build();
    }

    @NotNull
    public MaterialTextureData getTextureData() {
        return this.textureDataCache;
    }
}

