/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityColonyFlag
extends BlockEntity {
    private BannerPatternLayers patterns = BannerPatternLayers.EMPTY;
    public int colonyId = -1;

    public TileEntityColonyFlag(BlockPos pos, BlockState state) {
        super((BlockEntityType)MinecoloniesTileEntities.COLONY_FLAG.get(), pos, state);
    }

    public BannerPatternLayers getPatterns() {
        IColonyView view;
        if (this.level != null && this.level.getGameTime() % 20L == 0L && (view = IColonyManager.getInstance().getColonyView(this.colonyId, (ResourceKey<Level>)this.level.dimension())) != null) {
            this.patterns = view.getColonyFlag();
        }
        return this.patterns;
    }

    public void saveAdditional(CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("cbpatterns", Utils.serializeCodecMess(BannerPatternLayers.CODEC, provider, this.patterns));
        compound.putInt("colony", this.colonyId);
    }

    public void loadAdditional(CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        IColony colony;
        super.loadAdditional(compound, provider);
        if (compound.contains("cbpatterns")) {
            this.patterns = (BannerPatternLayers)Utils.deserializeCodecMess(BannerPatternLayers.CODEC, provider, compound.get("cbpatterns"));
        }
        this.colonyId = compound.getInt("colony");
        if (this.colonyId == -1 && this.hasLevel() && (colony = IColonyManager.getInstance().getIColony(this.getLevel(), this.worldPosition)) != null) {
            this.colonyId = colony.getID();
            this.setChanged();
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        return this.saveWithId(provider);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, @NotNull HolderLookup.Provider provider) {
        CompoundTag compound = packet.getTag();
        this.loadAdditional(compound, provider);
    }
}

