/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.ILocalResearchTree;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.research.effects.IResearchEffectManager;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.event.QuestObjectiveEventHandler;
import com.minecolonies.core.research.LocalResearch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class LocalResearchTree
implements ILocalResearchTree {
    private final Map<ResourceLocation, Map<ResourceLocation, ILocalResearch>> researchTree = new HashMap<ResourceLocation, Map<ResourceLocation, ILocalResearch>>();
    private final Map<ResourceLocation, ILocalResearch> inProgress = new HashMap<ResourceLocation, ILocalResearch>();
    private final Set<ResourceLocation> isComplete = new HashSet<ResourceLocation>();
    private final Set<ResourceLocation> maxLevelResearchCompleted = new HashSet<ResourceLocation>();
    public final IColony colony;

    public LocalResearchTree(IColony colony) {
        this.colony = colony;
    }

    @Override
    public ILocalResearch getResearch(ResourceLocation branch, ResourceLocation id) {
        if (!this.researchTree.containsKey(branch)) {
            return null;
        }
        return this.researchTree.get(branch).get(id);
    }

    @Override
    public boolean hasCompletedResearch(ResourceLocation researchId) {
        if (IGlobalResearchTree.getInstance().hasResearch(researchId)) {
            return this.isComplete.contains(researchId);
        }
        return true;
    }

    @Override
    public void addResearch(ResourceLocation branch, ILocalResearch research) {
        if (!this.researchTree.containsKey(branch)) {
            this.researchTree.put(branch, new HashMap());
        }
        if (!this.researchTree.get(branch).containsKey(research.getId())) {
            this.researchTree.get(branch).put(research.getId(), research);
        }
        if (research.getState() == ResearchState.IN_PROGRESS) {
            this.inProgress.put(research.getId(), research);
        } else if (research.getState() == ResearchState.FINISHED) {
            this.inProgress.remove(research.getId());
            this.isComplete.add(research.getId());
            QuestObjectiveEventHandler.onResearchComplete(this.colony, research.getId());
        }
        if (research.getDepth() == 6) {
            this.maxLevelResearchCompleted.add(branch);
        }
    }

    @Override
    public boolean branchFinishedHighestLevel(ResourceLocation branch) {
        return this.maxLevelResearchCompleted.contains(branch);
    }

    @Override
    public List<ILocalResearch> getResearchInProgress() {
        return ImmutableList.copyOf(this.inProgress.values());
    }

    @Override
    public void finishResearch(ResourceLocation id) {
        this.inProgress.remove(id);
        this.isComplete.add(id);
        QuestObjectiveEventHandler.onResearchComplete(this.colony, id);
    }

    @Override
    public void attemptBeginResearch(Player player, IColony colony, IGlobalResearch research) {
        if (colony.getResearchManager().getResearchTree().getResearch(research.getBranch(), research.getId()) == null) {
            if (player.isCreative()) {
                research.startResearch(colony.getResearchManager().getResearchTree());
                if (((Boolean)((ServerConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getServer()).researchCreativeCompletion.get()).booleanValue()) {
                    colony.getResearchManager().getResearchTree().getResearch(research.getBranch(), research.getId()).setProgress(IGlobalResearchTree.getInstance().getBranchData(research.getBranch()).getBaseTime(research.getDepth()));
                }
                colony.getResearchManager().markDirty();
                SoundUtils.playSuccessSound(player, player.blockPosition());
                colony.getResearchManager().markDirty();
                return;
            }
            InvWrapper playerInv = new InvWrapper((Container)player.getInventory());
            if (!research.hasEnoughResources((IItemHandler)playerInv)) {
                MessageUtils.format("com.minecolonies.coremod.research.costnotavailable", MutableComponent.create((ComponentContents)research.getName())).sendTo(player);
                SoundUtils.playErrorSound(player, player.blockPosition());
                return;
            }
            if (!research.getResearchRequirement().isEmpty()) {
                for (IResearchRequirement requirement : research.getResearchRequirement()) {
                    if (requirement.isFulfilled(colony)) continue;
                    MessageUtils.format("com.minecolonies.coremod.research.requirementnotmet", new Object[0]).sendTo(player);
                    SoundUtils.playErrorSound(player, player.blockPosition());
                    return;
                }
            }
            for (SizedIngredient cost : research.getCostList()) {
                int toRemoveLeft = cost.count();
                List<Integer> slotsWithMaterial = InventoryUtils.findAllSlotsInItemHandlerWith((IItemHandler)playerInv, (Predicate<ItemStack>)cost.ingredient());
                for (Integer slotNum : slotsWithMaterial) {
                    if ((toRemoveLeft -= playerInv.extractItem(slotNum.intValue(), toRemoveLeft, false).getCount()) <= 0) break;
                }
            }
            MessageUtils.format("com.minecolonies.coremod.research.started", MutableComponent.create((ComponentContents)research.getName())).sendTo(player);
            research.startResearch(colony.getResearchManager().getResearchTree());
            colony.getResearchManager().markDirty();
            SoundUtils.playSuccessSound(player, player.blockPosition());
        } else if (player.isCreative()) {
            if (((Boolean)((ServerConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getServer()).researchCreativeCompletion.get()).booleanValue()) {
                colony.getResearchManager().getResearchTree().getResearch(research.getBranch(), research.getId()).setProgress(IGlobalResearchTree.getInstance().getBranchData(research.getBranch()).getBaseTime(research.getDepth()));
                colony.getResearchManager().markDirty();
            }
        } else {
            MessageUtils.format("com.minecolonies.coremod.research.alreadystarted", new Object[0]).sendTo(player);
            SoundUtils.playErrorSound(player, player.blockPosition());
        }
        colony.markDirty();
    }

    @Override
    public void attemptResetResearch(Player player, IColony colony, ILocalResearch research) {
        if (research.getState() == ResearchState.IN_PROGRESS) {
            MessageUtils.format("com.minecolonies.coremod.research.stopped", MutableComponent.create((ComponentContents)IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getName())).sendTo(player);
            SoundUtils.playSuccessSound(player, player.blockPosition());
            this.removeResearch(research.getBranch(), research.getId());
            colony.getResearchManager().markDirty();
        } else if (research.getState() == ResearchState.FINISHED) {
            for (ResourceLocation childIds : IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getChildren()) {
                if (this.researchTree.get(research.getBranch()).get(childIds) == null) continue;
                MessageUtils.format("com.minecolonies.coremod.research.undo.haschilds", new Object[0]).sendTo(player);
                SoundUtils.playErrorSound(player, player.blockPosition());
                return;
            }
            if (!player.isCreative()) {
                List<ItemStorage> costList = IGlobalResearchTree.getInstance().getResearchResetCosts((HolderLookup.Provider)colony.getWorld().registryAccess());
                InvWrapper playerInv = new InvWrapper((Container)player.getInventory());
                for (ItemStorage cost : costList) {
                    int count = InventoryUtils.getItemCountInItemHandler((IItemHandler)playerInv, stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, cost.getItemStack(), !cost.ignoreDamageValue(), !cost.ignoreNBT()));
                    if (count >= cost.getAmount()) continue;
                    MessageUtils.format("com.minecolonies.coremod.research.costnotavailable", MutableComponent.create((ComponentContents)IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getName())).sendTo(player);
                    SoundUtils.playErrorSound(player, player.blockPosition());
                    return;
                }
                for (ItemStorage cost : costList) {
                    List<Integer> slotsWithMaterial = InventoryUtils.findAllSlotsInItemHandlerWith((IItemHandler)playerInv, stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, cost.getItemStack(), !cost.ignoreDamageValue(), !cost.ignoreNBT()));
                    int amount = cost.getAmount();
                    for (Integer slotNum : slotsWithMaterial) {
                        if ((amount -= playerInv.extractItem(slotNum.intValue(), amount, false).getCount()) <= 0) break;
                    }
                }
            }
            MessageUtils.format("com.minecolonies.coremod.research.undo", MutableComponent.create((ComponentContents)IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getName())).sendTo(player);
            SoundUtils.playSuccessSound(player, player.blockPosition());
            this.removeResearch(research.getBranch(), research.getId());
            this.resetEffects(colony);
            colony.getResearchManager().markDirty();
        }
        colony.markDirty();
    }

    private void removeResearch(ResourceLocation branch, ResourceLocation id) {
        if (!this.researchTree.get(branch).containsKey(id)) {
            Log.getLogger().warn("Something went wrong: player attempted to reset research that does not exist or is not started");
        }
        this.researchTree.get(branch).remove(id);
        this.inProgress.remove(id);
        this.isComplete.remove(id);
        if (IGlobalResearchTree.getInstance().getResearch(branch, id).getDepth() == 6) {
            this.maxLevelResearchCompleted.remove(branch);
        }
    }

    private void resetEffects(IColony colony) {
        if (colony != null) {
            colony.getResearchManager().getResearchEffects().removeAllEffects();
            for (Map.Entry<ResourceLocation, Map<ResourceLocation, ILocalResearch>> branch : this.researchTree.entrySet()) {
                for (Map.Entry<ResourceLocation, ILocalResearch> research : branch.getValue().entrySet()) {
                    if (research.getValue().getState() != ResearchState.FINISHED) continue;
                    for (IResearchEffect<?> effect : IGlobalResearchTree.getInstance().getResearch(branch.getKey(), research.getValue().getId()).getEffects()) {
                        colony.getResearchManager().getResearchEffects().applyEffect(effect);
                        colony.getResearchManager().markDirty();
                    }
                }
            }
        }
    }

    @Override
    public void writeToNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        ListTag researchList = new ListTag();
        for (Map<ResourceLocation, ILocalResearch> researchMap : this.researchTree.values()) {
            for (ILocalResearch research : researchMap.values()) {
                researchList.add((Object)StandardFactoryController.getInstance().serializeTag(provider, research));
            }
        }
        compound.put("researchTree", (Tag)researchList);
    }

    @Override
    public void readFromNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound, IResearchEffectManager effects) {
        this.researchTree.clear();
        this.inProgress.clear();
        this.isComplete.clear();
        this.maxLevelResearchCompleted.clear();
        NBTUtils.streamCompound(compound.getList("researchTree", 10)).map(researchCompound -> (ILocalResearch)StandardFactoryController.getInstance().deserializeTag(provider, (CompoundTag)researchCompound)).forEach(research -> {
            if (!MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().hasResearch(research.getBranch(), research.getId())) {
                if (research.getBranch().getNamespace().contains("minecraft")) {
                    ResearchState currentState = research.getState();
                    int progress = research.getProgress();
                    research = new LocalResearch(new ResourceLocation("minecolonies", research.getId().getPath()), new ResourceLocation("minecolonies", research.getBranch().getPath()), research.getDepth());
                    research.setState(currentState);
                    research.setProgress(progress);
                } else if (((Boolean)((ServerConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getServer()).researchDebugLog.get()).booleanValue()) {
                    Log.getLogger().warn("Research " + String.valueOf(research.getId()) + " was in colony save file, but was not in CompatMap.");
                }
            }
            if (research.getState() == ResearchState.FINISHED) {
                if (MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().hasResearch(research.getBranch(), research.getId())) {
                    for (IResearchEffect<?> effect : MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().getResearch(research.getBranch(), research.getId()).getEffects()) {
                        effects.applyEffect(effect);
                    }
                } else if (((Boolean)((ServerConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getServer()).researchDebugLog.get()).booleanValue()) {
                    Log.getLogger().warn("Research " + String.valueOf(research.getId()) + " was in colony save file, but not found as valid current research.  Progress on this research may be reset.");
                }
            }
            this.addResearch(research.getBranch(), (ILocalResearch)research);
        });
    }

    @Override
    public List<ResourceLocation> getCompletedList() {
        return new ArrayList<ResourceLocation>(this.isComplete);
    }

    @Override
    public boolean isComplete(ResourceLocation location) {
        return this.isComplete.contains(location);
    }
}

