/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.research.effects.ModResearchEffects;
import com.minecolonies.api.research.effects.registry.ResearchEffectEntry;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GlobalResearchEffect
implements IResearchEffect<Double> {
    private static final String TAG_ID = "id";
    private static final String TAG_DESC = "desc";
    private static final String TAG_SUBTITLE = "subtitle";
    private static final String TAG_EFFECT = "effect";
    private static final String TAG_DISPLAY_EFFECT = "display";
    private double effect;
    private final double displayEffect;
    private final ResourceLocation id;
    private final TranslatableContents desc;
    private final TranslatableContents subtitle;

    public GlobalResearchEffect(ResourceLocation id, double effect, double displayEffect) {
        this.id = id;
        this.effect = effect;
        this.displayEffect = displayEffect;
        this.desc = new TranslatableContents("com." + this.id.getNamespace() + ".research." + this.id.getPath().replaceAll("[ /:]", ".") + ".description", (String)null, List.of(Double.valueOf(displayEffect), Double.valueOf(effect), Long.valueOf(Math.round(displayEffect * 100.0)), Long.valueOf(Math.round(effect * 100.0))).toArray());
        this.subtitle = new TranslatableContents("", (String)null, TranslatableContents.NO_ARGS);
    }

    public GlobalResearchEffect(ResourceLocation id, double effect, double displayEffect, TranslatableContents desc, TranslatableContents subtitle) {
        this.id = id;
        this.effect = effect;
        this.displayEffect = displayEffect;
        String key = desc.getKey();
        this.desc = key.isEmpty() ? new TranslatableContents("com." + this.id.getPath() + ".research." + this.id.getNamespace().replaceAll("[ /:]", ".") + ".description", null, List.of(Double.valueOf(displayEffect), Double.valueOf(effect), Long.valueOf(Math.round(displayEffect * 100.0)), Long.valueOf(Math.round(effect * 100.0))).toArray()) : new TranslatableContents(key, null, List.of(Double.valueOf(displayEffect), Double.valueOf(effect), Long.valueOf(Math.round(displayEffect * 100.0)), Long.valueOf(Math.round(effect * 100.0))).toArray());
        this.subtitle = subtitle;
    }

    public GlobalResearchEffect(CompoundTag nbt) {
        this.id = ResourceLocation.parse((String)nbt.getString(TAG_ID));
        this.effect = nbt.getDouble(TAG_EFFECT);
        this.displayEffect = nbt.getDouble(TAG_DISPLAY_EFFECT);
        this.desc = new TranslatableContents(nbt.getString(TAG_DESC), null, List.of(Double.valueOf(this.displayEffect), Double.valueOf(this.effect), Long.valueOf(Math.round(this.displayEffect * 100.0)), Long.valueOf(Math.round(this.effect * 100.0))).toArray());
        this.subtitle = new TranslatableContents(nbt.getString(TAG_SUBTITLE), null, TranslatableContents.NO_ARGS);
    }

    @Override
    public Double getEffect() {
        return this.effect;
    }

    @Override
    public void setEffect(Double effect) {
        this.effect = effect;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public TranslatableContents getDesc() {
        return this.desc;
    }

    @Override
    public TranslatableContents getSubtitle() {
        return this.subtitle;
    }

    @Override
    public boolean overrides(@NotNull IResearchEffect<?> other) {
        return Math.abs(this.effect) > Math.abs(((GlobalResearchEffect)other).effect);
    }

    @Override
    public ResearchEffectEntry getRegistryEntry() {
        return (ResearchEffectEntry)ModResearchEffects.globalResearchEffect.get();
    }

    @Override
    public CompoundTag writeToNBT() {
        String descKey = this.desc.getKey();
        String subtitleKey = this.subtitle.getKey();
        CompoundTag nbt = new CompoundTag();
        nbt.putString(TAG_ID, this.id.toString());
        nbt.putString(TAG_DESC, descKey);
        nbt.putString(TAG_SUBTITLE, subtitleKey);
        nbt.putDouble(TAG_EFFECT, this.effect);
        nbt.putDouble(TAG_DISPLAY_EFFECT, this.displayEffect);
        return nbt;
    }
}

