/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.api.research.registry.ResearchRequirementEntry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class BuildingResearchRequirement
implements IResearchRequirement {
    private static final String TAG_BUILDING_NAME = "building-name";
    private static final String TAG_BUILDING_LVL = "building-lvl";
    private static final String TAG_BUILDING_SINGLE = "building-single";
    private final int buildingLevel;
    private final String building;
    private final boolean singleBuilding;

    public BuildingResearchRequirement(int buildingLevel, String building, boolean singleBuilding) {
        this.buildingLevel = buildingLevel;
        this.building = building;
        this.singleBuilding = singleBuilding;
    }

    public BuildingResearchRequirement(CompoundTag nbt) {
        this.buildingLevel = nbt.getInt(TAG_BUILDING_LVL);
        this.building = nbt.getString(TAG_BUILDING_NAME);
        this.singleBuilding = nbt.getBoolean(TAG_BUILDING_SINGLE);
    }

    public String getBuilding() {
        return this.building;
    }

    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    @Override
    public boolean isFulfilled(IColony colony) {
        return colony.hasBuilding(this.building, this.buildingLevel, this.singleBuilding);
    }

    @Override
    public MutableComponent getDesc() {
        if (this.singleBuilding) {
            return Component.translatableEscape((String)"com.minecolonies.coremod.research.requirement.building.mandatory.level", (Object[])new Object[]{Component.translatableEscape((String)("com.minecolonies.building." + this.building), (Object[])new Object[0]), this.buildingLevel});
        }
        return Component.translatableEscape((String)"com.minecolonies.coremod.research.requirement.building.level", (Object[])new Object[]{Component.translatableEscape((String)("com.minecolonies.building." + this.building), (Object[])new Object[0]), this.buildingLevel});
    }

    @Override
    public ResearchRequirementEntry getRegistryEntry() {
        return (ResearchRequirementEntry)ModResearchRequirements.buildingResearchRequirement.get();
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString(TAG_BUILDING_NAME, this.building);
        nbt.putInt(TAG_BUILDING_LVL, this.buildingLevel);
        nbt.putBoolean(TAG_BUILDING_SINGLE, this.singleBuilding);
        return nbt;
    }
}

