/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.quests.objectives;

import com.google.gson.JsonObject;
import com.minecolonies.api.quests.IDialogueObjectiveTemplate;
import com.minecolonies.api.quests.IQuestDeliveryObjective;
import com.minecolonies.api.quests.IQuestDialogueAnswer;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.quests.objectives.DialogueObjectiveTemplateTemplate;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class DeliveryObjectiveTemplateTemplate
extends DialogueObjectiveTemplateTemplate
implements IQuestDeliveryObjective {
    private final ItemStack item;
    private final int quantity;
    private final int nextObjective;
    private final String nbtMode;
    private IDialogueObjectiveTemplate.DialogueElement readyDialogueElement;
    private IDialogueObjectiveTemplate.DialogueElement waitingDialogueElement;

    public DeliveryObjectiveTemplateTemplate(int target, ItemStack item, int quantity, int nextObjective, List<Integer> rewards, String nbtMode) {
        super(target, null, rewards);
        this.item = item;
        this.quantity = quantity;
        this.nextObjective = nextObjective;
        this.nbtMode = nbtMode;
        this.buildDialogueTrees();
    }

    private void buildDialogueTrees() {
        MutableComponent ready = Component.translatableEscape((String)"com.minecolonies.coremod.questobjectives.delivery.ready", (Object[])new Object[]{this.item.getDisplayName()});
        IDialogueObjectiveTemplate.AnswerElement ready1 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.translatableEscape((String)"com.minecolonies.coremod.questobjectives.delivery.ready.give", (Object[])new Object[0]), new IQuestDialogueAnswer.NextObjectiveDialogueAnswer(this.nextObjective));
        IDialogueObjectiveTemplate.AnswerElement ready2 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.translatableEscape((String)"com.minecolonies.coremod.questobjectives.delivery.ready.later", (Object[])new Object[0]), new IQuestDialogueAnswer.CloseUIDialogueAnswer());
        this.readyDialogueElement = new IDialogueObjectiveTemplate.DialogueElement((Component)ready, List.of(ready1, ready2));
        MutableComponent waiting = Component.translatableEscape((String)"com.minecolonies.coremod.questobjectives.delivery.waiting", (Object[])new Object[]{this.item.getDisplayName()});
        IDialogueObjectiveTemplate.AnswerElement waiting1 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.translatableEscape((String)"com.minecolonies.coremod.questobjectives.answer.later", (Object[])new Object[0]), new IQuestDialogueAnswer.CloseUIDialogueAnswer());
        IDialogueObjectiveTemplate.AnswerElement waiting2 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.translatableEscape((String)"com.minecolonies.coremod.questobjectives.delivery.waiting.cancel", (Object[])new Object[0]), new IQuestDialogueAnswer.QuestCancellationDialogueAnswer());
        this.waitingDialogueElement = new IDialogueObjectiveTemplate.DialogueElement((Component)waiting, List.of(waiting1, waiting2));
    }

    public static IQuestObjectiveTemplate createObjective(@NotNull HolderLookup.Provider provider, JsonObject jsonObject) {
        JsonObject details = jsonObject.getAsJsonObject("details");
        int target = details.get("target").getAsInt();
        ItemStack item = (ItemStack)Utils.deserializeCodecMessFromJson(ItemStack.CODEC, provider, details.get("item"));
        int nextObj = details.has("next-objective") ? details.get("next-objective").getAsInt() : -1;
        String nbtMode = details.has("nbt-mode") ? details.get("nbt-mode").getAsString() : "";
        return new DeliveryObjectiveTemplateTemplate(target, item, item.getCount(), nextObj, DeliveryObjectiveTemplateTemplate.parseRewards(jsonObject), nbtMode);
    }

    @Override
    public boolean hasItem(Player player, IQuestInstance colonyQuest) {
        return InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((Container)player.getInventory()), itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, this.item, !this.nbtMode.equals("any"), !this.nbtMode.equals("any"))) >= this.quantity;
    }

    @Override
    public boolean tryDiscountItem(Player player, IQuestInstance colonyQuest) {
        return InventoryUtils.attemptReduceStackInItemHandler((IItemHandler)new InvWrapper((Container)player.getInventory()), this.item, this.quantity, this.nbtMode.equals("any"), this.nbtMode.equals("any"));
    }

    @Override
    public IDialogueObjectiveTemplate.DialogueElement getDialogueTree() {
        return this.waitingDialogueElement;
    }

    @Override
    public IDialogueObjectiveTemplate.DialogueElement getReadyDialogueTree() {
        return this.readyDialogueElement;
    }

    @Override
    public Component getProgressText(IQuestInstance quest, Style style) {
        return Component.translatableEscape((String)"com.minecolonies.coremod.questobjectives.delivery.progress", (Object[])new Object[]{0, this.quantity, this.item.getDisplayName().plainCopy().setStyle(style)});
    }
}

