/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.quests.objectives;

import com.google.gson.JsonObject;
import com.minecolonies.api.quests.IDialogueObjectiveTemplate;
import com.minecolonies.api.quests.IObjectiveInstance;
import com.minecolonies.api.quests.IQuestDialogueAnswer;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.event.QuestObjectiveEventHandler;
import com.minecolonies.core.quests.objectives.DialogueObjectiveTemplateTemplate;
import com.minecolonies.core.quests.objectives.IBreakBlockObjectiveTemplate;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class BreakBlockObjectiveTemplate
extends DialogueObjectiveTemplateTemplate
implements IBreakBlockObjectiveTemplate {
    private final int blocksToMine;
    private final Block blockToMine;
    private final int nextObjective;

    public BreakBlockObjectiveTemplate(int target, int blocksToMine, Block blockToMine, int nextObjective, List<Integer> rewards) {
        super(target, BreakBlockObjectiveTemplate.buildDialogueTree(blockToMine), rewards);
        this.blocksToMine = blocksToMine;
        this.nextObjective = nextObjective;
        this.blockToMine = blockToMine;
    }

    @NotNull
    private static IDialogueObjectiveTemplate.DialogueElement buildDialogueTree(Block blockToMine) {
        MutableComponent text = Component.translatableEscape((String)"com.minecolonies.coremod.questobjectives.breakblock", (Object[])new Object[]{blockToMine.getName()});
        IDialogueObjectiveTemplate.AnswerElement answer1 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.translatableEscape((String)"com.minecolonies.coremod.questobjectives.answer.later", (Object[])new Object[0]), new IQuestDialogueAnswer.CloseUIDialogueAnswer());
        IDialogueObjectiveTemplate.AnswerElement answer2 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.translatableEscape((String)"com.minecolonies.coremod.questobjectives.answer.cancel", (Object[])new Object[0]), new IQuestDialogueAnswer.QuestCancellationDialogueAnswer());
        return new IDialogueObjectiveTemplate.DialogueElement((Component)text, List.of(answer1, answer2));
    }

    public static IQuestObjectiveTemplate createObjective(@NotNull HolderLookup.Provider provider, JsonObject jsonObject) {
        JsonObject details = jsonObject.getAsJsonObject("details");
        int target = details.get("target").getAsInt();
        int quantity = details.get("qty").getAsInt();
        Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)details.get("block").getAsString()));
        int nextObj = details.has("next-objective") ? details.get("next-objective").getAsInt() : -1;
        return new BreakBlockObjectiveTemplate(target, quantity, block, nextObj, BreakBlockObjectiveTemplate.parseRewards(jsonObject));
    }

    @Override
    public IObjectiveInstance startObjective(IQuestInstance colonyQuest) {
        super.startObjective(colonyQuest);
        if (colonyQuest.getColony() instanceof Colony) {
            QuestObjectiveEventHandler.addQuestMineObjectiveListener(this.blockToMine, colonyQuest.getAssignedPlayer(), colonyQuest);
        }
        return this.createObjectiveInstance();
    }

    @Override
    public Component getProgressText(IQuestInstance quest, Style style) {
        IObjectiveInstance iObjectiveInstance = quest.getCurrentObjectiveInstance();
        if (iObjectiveInstance instanceof BlockMiningProgressInstance) {
            BlockMiningProgressInstance progress = (BlockMiningProgressInstance)iObjectiveInstance;
            return Component.translatableEscape((String)"com.minecolonies.coremod.questobjectives.breakblock.progress", (Object[])new Object[]{progress.currentProgress, this.blocksToMine, this.blockToMine.getName().setStyle(style)});
        }
        return Component.empty();
    }

    @Override
    @NotNull
    public IObjectiveInstance createObjectiveInstance() {
        return new BlockMiningProgressInstance(this);
    }

    @Override
    public void onCancellation(IQuestInstance colonyQuest) {
        this.cleanupListener(colonyQuest);
    }

    private void cleanupListener(IQuestInstance colonyQuest) {
        if (colonyQuest.getColony() instanceof Colony) {
            QuestObjectiveEventHandler.removeQuestMineObjectiveListener(this.blockToMine, colonyQuest.getAssignedPlayer(), colonyQuest);
        }
    }

    @Override
    public void onBlockBreak(IObjectiveInstance blockMiningProgressData, IQuestInstance colonyQuest, Player player) {
        if (blockMiningProgressData.isFulfilled()) {
            return;
        }
        ++((BlockMiningProgressInstance)blockMiningProgressData).currentProgress;
        if (blockMiningProgressData.isFulfilled()) {
            this.cleanupListener(colonyQuest);
            colonyQuest.advanceObjective(player, this.nextObjective);
        }
    }

    @Override
    public void onWorldLoad(IQuestInstance colonyQuest) {
        super.onWorldLoad(colonyQuest);
        if (colonyQuest.getColony() instanceof Colony) {
            QuestObjectiveEventHandler.addQuestMineObjectiveListener(this.blockToMine, colonyQuest.getAssignedPlayer(), colonyQuest);
        }
    }

    private static class BlockMiningProgressInstance
    implements IObjectiveInstance {
        private int currentProgress = 0;
        private final BreakBlockObjectiveTemplate template;

        public BlockMiningProgressInstance(IQuestObjectiveTemplate template) {
            this.template = (BreakBlockObjectiveTemplate)template;
        }

        @Override
        public boolean isFulfilled() {
            return this.currentProgress >= this.template.blocksToMine;
        }

        public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putInt("quantity", this.currentProgress);
            return compoundTag;
        }

        @Override
        public int getMissingQuantity() {
            return this.template.blocksToMine > this.currentProgress ? this.template.blocksToMine - this.currentProgress : 0;
        }

        public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            this.currentProgress = nbt.getInt("quantity");
        }
    }
}

