/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers;

import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.blocks.schematic.BlockWaypoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WayPointBlockPlacementHandler
implements IPlacementHandler {
    public boolean canHandle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        return blockState.getBlock() instanceof BlockWaypoint;
    }

    public IPlacementHandler.ActionProcessingResult handle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
        world.removeBlock(pos, false);
        IColony colony = IColonyManager.getInstance().getClosestColony(world, pos);
        if (colony != null) {
            if (!complete) {
                colony.addWayPoint(pos, Blocks.AIR.defaultBlockState());
            } else {
                world.setBlockAndUpdate(pos, blockState);
            }
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    public List<ItemStack> getRequiredItems(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
        if (complete) {
            return Collections.singletonList(BlockUtils.getItemStackFromBlockState((BlockState)blockState));
        }
        return new ArrayList<ItemStack>();
    }
}

