/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.blocks.BlockScarecrow;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldPlacementHandler
implements IPlacementHandler {
    public boolean canHandle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        return blockState.getBlock() instanceof BlockScarecrow;
    }

    public IPlacementHandler.ActionProcessingResult handle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, RotationMirror settings) {
        if (world.getBlockState(pos).getBlock() == ModBlocks.blockScarecrow) {
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }
        if (((DoubleBlockHalf)blockState.getValue((Property)DoorBlock.HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
            world.setBlock(pos, (BlockState)blockState.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), 3);
            world.setBlock(pos.above(), (BlockState)blockState.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        }
        if (tileEntityData != null) {
            try {
                PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos, (RotationMirror)settings);
                blockState.getBlock().setPlacedBy(world, pos, blockState, null, BlockUtils.getItemStackFromBlockState((BlockState)blockState));
            }
            catch (Exception ex) {
                Log.getLogger().warn("Unable to place TileEntity");
            }
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    public List<ItemStack> getRequiredItems(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        if (((DoubleBlockHalf)blockState.getValue((Property)DoorBlock.HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
            itemList.add(BlockUtils.getItemStackFromBlockState((BlockState)blockState));
        }
        return itemList;
    }
}

