/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers;

import com.ldtteam.domumornamentum.block.AbstractPostBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.decorative.FancyDoorBlock;
import com.ldtteam.domumornamentum.block.decorative.FancyTrapdoorBlock;
import com.ldtteam.domumornamentum.block.decorative.PanelBlock;
import com.ldtteam.domumornamentum.block.decorative.PillarBlock;
import com.ldtteam.domumornamentum.block.vanilla.DoorBlock;
import com.ldtteam.domumornamentum.block.vanilla.TrapdoorBlock;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoBlockPlacementHandler
implements IPlacementHandler {
    public boolean canHandle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        return blockState.getBlock() instanceof IMateriallyTexturedBlock && blockState.getBlock() != ModBlocks.blockRack;
    }

    public IPlacementHandler.ActionProcessingResult handle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, RotationMirror settings) {
        BlockState placementState = blockState;
        if (blockState.getBlock() instanceof WallBlock || blockState.getBlock() instanceof FenceBlock || blockState.getBlock() instanceof PillarBlock || blockState.getBlock() instanceof IronBarsBlock) {
            try {
                BlockState tempState = blockState.getBlock().getStateForPlacement(new BlockPlaceContext(world, null, InteractionHand.MAIN_HAND, ItemStack.EMPTY, new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.DOWN, pos, true)));
                if (tempState != null) {
                    placementState = tempState;
                }
            }
            catch (Exception tempState) {
                // empty catch block
            }
        }
        if (world.getBlockState(pos).equals(placementState)) {
            world.removeBlock(pos, false);
            WorldUtil.setBlockState((LevelAccessor)world, pos, placementState, 3);
            if (tileEntityData != null) {
                try {
                    PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos, (RotationMirror)settings);
                    placementState.getBlock().setPlacedBy(world, pos, placementState, null, placementState.getBlock().getCloneItemStack(placementState, (HitResult)new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.NORTH, pos, false), (LevelReader)world, pos, null));
                }
                catch (Exception ex) {
                    Log.getLogger().warn("Unable to place TileEntity");
                }
            }
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
        if (!WorldUtil.setBlockState((LevelAccessor)world, pos, placementState, 3)) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
        if (tileEntityData != null) {
            try {
                PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos, (RotationMirror)settings);
                blockState.getBlock().setPlacedBy(world, pos, placementState, null, placementState.getBlock().getCloneItemStack(placementState, (HitResult)new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.NORTH, pos, false), (LevelReader)world, pos, null));
            }
            catch (Exception ex) {
                Log.getLogger().warn("Unable to place TileEntity");
            }
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    public List<ItemStack> getRequiredItems(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        if (tileEntityData != null) {
            BlockPos blockpos = new BlockPos(tileEntityData.getInt("x"), tileEntityData.getInt("y"), tileEntityData.getInt("z"));
            BlockEntity tileEntity = BlockEntity.loadStatic((BlockPos)blockpos, (BlockState)blockState, (CompoundTag)tileEntityData, (HolderLookup.Provider)world.registryAccess());
            if (tileEntity == null) {
                return Collections.emptyList();
            }
            Object property = blockState.getBlock() instanceof DoorBlock ? DoorBlock.TYPE : (blockState.getBlock() instanceof FancyDoorBlock ? FancyDoorBlock.TYPE : (blockState.getBlock() instanceof TrapdoorBlock ? TrapdoorBlock.TYPE : (blockState.getBlock() instanceof FancyTrapdoorBlock ? FancyTrapdoorBlock.TYPE : (blockState.getBlock() instanceof PanelBlock ? PanelBlock.TYPE : (blockState.getBlock() instanceof AbstractPostBlock ? AbstractPostBlock.TYPE : null)))));
            itemList.add(property == null ? BlockUtils.getMaterializedItemStack((BlockEntity)tileEntity, (HolderLookup.Provider)world.registryAccess(), (Property[])new Property[0]) : BlockUtils.getMaterializedItemStack((BlockEntity)tileEntity, (HolderLookup.Provider)world.registryAccess(), (Property[])new Property[]{property}));
        }
        itemList.removeIf(ItemStackUtils::isEmpty);
        return itemList;
    }
}

