/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.worker;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ToggleRecipeMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"toggle_recipe", ToggleRecipeMessage::new);
    private final int recipeLocation;
    private final int id;

    public ToggleRecipeMessage(@NotNull IBuildingView building, int location, int id) {
        super(TYPE, building);
        this.recipeLocation = location;
        this.id = id;
    }

    protected ToggleRecipeMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.recipeLocation = buf.readInt();
        this.id = buf.readInt();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.recipeLocation);
        buf.writeInt(this.id);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, IBuilding building) {
        if (building.getModule(this.id) != null) {
            AbstractCraftingBuildingModule module = (AbstractCraftingBuildingModule)building.getModule(this.id);
            module.toggle(this.recipeLocation);
        }
    }
}

