/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.worker;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.advancements.BuildingAddRecipeTrigger;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import com.minecolonies.core.util.AdvancementUtils;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class AddRemoveRecipeMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"add_remove_recipe", AddRemoveRecipeMessage::new);
    private final boolean remove;
    private final IRecipeStorage storage;
    private final int id;

    public AddRemoveRecipeMessage(IBuildingView building, boolean remove, IRecipeStorage storage, int id) {
        super(TYPE, building);
        this.remove = remove;
        this.storage = storage;
        this.id = id;
    }

    public AddRemoveRecipeMessage(IBuildingView building, List<ItemStorage> input, int gridSize, ItemStack primaryOutput, List<ItemStack> additionalOutputs, boolean remove, int id) {
        super(TYPE, building);
        this.remove = remove;
        this.storage = gridSize == 1 ? (IRecipeStorage)StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{input, gridSize, primaryOutput, Blocks.FURNACE}) : (IRecipeStorage)StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{input, gridSize, primaryOutput, Blocks.AIR, null, null, null, additionalOutputs});
        this.id = id;
    }

    public AddRemoveRecipeMessage(IBuildingView building, List<ItemStorage> input, int gridSize, ItemStack primaryOutput, boolean remove, Block intermediary, int id) {
        super(TYPE, building);
        this.remove = remove;
        if (gridSize != 1) {
            throw new UnsupportedOperationException("Not used now, implement it later if needed..");
        }
        this.storage = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{input, gridSize, primaryOutput, intermediary});
        this.id = id;
    }

    protected AddRemoveRecipeMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.storage = (IRecipeStorage)StandardFactoryController.getInstance().deserialize(buf);
        this.remove = buf.readBoolean();
        this.id = buf.readInt();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        StandardFactoryController.getInstance().serialize(buf, this.storage);
        buf.writeBoolean(this.remove);
        buf.writeInt(this.id);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, IBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.id);
        if (!(iBuildingModule instanceof AbstractCraftingBuildingModule)) {
            return;
        }
        AbstractCraftingBuildingModule module = (AbstractCraftingBuildingModule)iBuildingModule;
        if (this.remove) {
            module.removeRecipe(this.storage.getToken());
            SoundUtils.playSuccessSound((Player)player, player.blockPosition());
        } else {
            IToken<?> token = IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(this.storage);
            if (!module.addRecipe(token)) {
                SoundUtils.playErrorSound((Player)player, player.blockPosition());
                MessageUtils.format("com.minecolonies.coremod.recipe.unable", Component.translatableEscape((String)building.getBuildingDisplayName(), (Object[])new Object[0])).sendTo(new Player[]{player});
            } else {
                SoundUtils.playSuccessSound((Player)player, player.blockPosition());
                AdvancementUtils.TriggerAdvancementPlayersForColony(colony, playerMP -> ((BuildingAddRecipeTrigger)((Object)((Object)AdvancementTriggers.BUILDING_ADD_RECIPE.get()))).trigger((ServerPlayer)playerMP, this.storage));
                MessageUtils.format("com.minecolonies.coremod.gui.recipe.done", new Object[0]).sendTo(new Player[]{player});
            }
        }
        building.markDirty();
    }
}

