/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.guard;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class GuardSetMinePosMessage
extends AbstractBuildingServerMessage<AbstractBuildingGuards> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"guard_set_mine_pos", GuardSetMinePosMessage::new);
    private BlockPos minePos;

    public GuardSetMinePosMessage(@NotNull AbstractBuildingGuards.View building, BlockPos minePos) {
        super(TYPE, building);
        this.minePos = minePos;
    }

    public GuardSetMinePosMessage(@NotNull AbstractBuildingGuards.View building) {
        super(TYPE, building);
        this.minePos = null;
    }

    protected GuardSetMinePosMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.minePos = buf.readBoolean() ? buf.readBlockPos() : null;
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.minePos != null);
        if (this.minePos != null) {
            buf.writeBlockPos(this.minePos);
        }
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, AbstractBuildingGuards building) {
        IBuilding miner = building.getColony().getBuildingManager().getBuilding(this.minePos == null ? building.getMinePos() : this.minePos);
        if (miner instanceof BuildingMiner) {
            building.setMinePos(this.minePos);
        }
    }
}

