/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IMinimumStockModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class RemoveMinimumStockFromBuildingModuleMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"remove_minimum_stock_from_building_module", RemoveMinimumStockFromBuildingModuleMessage::new);
    private int moduleId;
    private ItemStack itemStack;

    public RemoveMinimumStockFromBuildingModuleMessage(IBuildingView building, ItemStack itemStack, int moduleId) {
        super(TYPE, building);
        this.itemStack = itemStack;
        this.moduleId = moduleId;
    }

    protected RemoveMinimumStockFromBuildingModuleMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.itemStack = Utils.deserializeCodecMess(buf);
        this.moduleId = buf.readInt();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        Utils.serializeCodecMess(buf, this.itemStack);
        buf.writeInt(this.moduleId);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, IBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.moduleId);
        if (iBuildingModule instanceof IMinimumStockModule) {
            IMinimumStockModule module = (IMinimumStockModule)iBuildingModule;
            module.removeMinimumStock(this.itemStack);
        }
    }
}

