/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class BuildRequestMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"build_request", BuildRequestMessage::new);
    private final Mode mode;
    private final BlockPos builder;

    public BuildRequestMessage(@NotNull IBuildingView building, Mode mode, BlockPos builder) {
        super(TYPE, building);
        this.mode = mode;
        this.builder = builder;
    }

    protected BuildRequestMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.mode = Mode.values()[buf.readInt()];
        this.builder = buf.readBlockPos();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.mode.ordinal());
        buf.writeBlockPos(this.builder);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, IBuilding building) {
        if (building.hasWorkOrder()) {
            building.removeWorkOrder();
        } else {
            switch (this.mode.ordinal()) {
                case 0: {
                    building.requestUpgrade((Player)player, this.builder);
                    break;
                }
                case 1: {
                    building.requestRepair(this.builder);
                    break;
                }
                case 2: {
                    building.requestRemoval((Player)player, this.builder);
                    for (BlockPos childPos : building.getChildren()) {
                        IBuilding childBuilding = colony.getBuildingManager().getBuilding(childPos);
                        if (childBuilding == null) continue;
                        childBuilding.requestRemoval((Player)player, this.builder);
                    }
                    break;
                }
            }
        }
    }

    public static enum Mode {
        BUILD,
        REPAIR,
        REMOVE;

    }
}

