/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.colony.buildings.modules.RestaurantMenuModule;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class AlterRestaurantMenuItemMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"alter_restaurant_menu_module", AlterRestaurantMenuItemMessage::new);
    private ItemStack itemStack;
    private int id;
    private boolean add;

    public static AlterRestaurantMenuItemMessage addMenuItem(IBuildingView building, ItemStack itemStack, int runtimeID) {
        return new AlterRestaurantMenuItemMessage(building, itemStack, runtimeID, true);
    }

    public static AlterRestaurantMenuItemMessage removeMenuItem(IBuildingView building, ItemStack itemStack, int runtimeID) {
        return new AlterRestaurantMenuItemMessage(building, itemStack, runtimeID, false);
    }

    private AlterRestaurantMenuItemMessage(IBuildingView building, ItemStack itemStack, int runtimeID, boolean add) {
        super(TYPE, building);
        this.itemStack = itemStack;
        this.id = runtimeID;
        this.add = add;
    }

    protected AlterRestaurantMenuItemMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.itemStack = Utils.deserializeCodecMess(buf);
        this.id = buf.readInt();
        this.add = buf.readBoolean();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        Utils.serializeCodecMess(buf, this.itemStack);
        buf.writeInt(this.id);
        buf.writeBoolean(this.add);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, IBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.id);
        if (iBuildingModule instanceof RestaurantMenuModule) {
            RestaurantMenuModule restaurantMenuModule = (RestaurantMenuModule)iBuildingModule;
            if (this.add) {
                restaurantMenuModule.addMenuItem(this.itemStack);
            } else {
                restaurantMenuModule.removeMenuItem(this.itemStack);
            }
        }
    }
}

