/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class BlockParticleEffectMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"block_particle_effect", BlockParticleEffectMessage::new);
    public static final int BREAK_BLOCK = -1;
    private final BlockPos pos;
    private final BlockState block;
    private final int side;

    public BlockParticleEffectMessage(BlockPos pos, @NotNull BlockState state, int side) {
        super(TYPE);
        this.pos = pos;
        this.block = state;
        this.side = side;
    }

    public BlockParticleEffectMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.pos = buf.readBlockPos();
        this.block = Block.stateById((int)buf.readInt());
        this.side = buf.readInt();
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeInt(Block.getId((BlockState)this.block));
        buf.writeInt(this.side);
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        if (this.side == -1) {
            Minecraft.getInstance().particleEngine.destroy(this.pos, this.block);
        } else {
            Minecraft.getInstance().particleEngine.crack(this.pos, Direction.from3DDataValue((int)this.side));
        }
    }
}

